/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.IPageSite;
import org.simantics.browsing.ui.swt.IContextMenuInitializer;

public class ContextMenuInitializer
implements IContextMenuInitializer {
    private final String text;
    private final String id;

    public ContextMenuInitializer(String id) {
        this("", id);
    }

    public ContextMenuInitializer(String text, String id) {
        this.text = text;
        this.id = id;
    }

    @Override
    public IMenuManager createContextMenu(Control control, ISelectionProvider selectionProvider, IWorkbenchSite site) {
        MenuManager mm = new MenuManager(this.text, this.id);
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ContextMenuInitializer.this.initializeOpenedMenu(manager);
            }
        });
        Menu menu = mm.createContextMenu(control);
        control.setMenu(menu);
        if (site != null) {
            if (site instanceof IWorkbenchPartSite) {
                ((IWorkbenchPartSite)site).registerContextMenu(mm.getId(), mm, selectionProvider);
            } else if (site instanceof IPageSite) {
                ((IPageSite)site).registerContextMenu(mm.getId(), mm, selectionProvider);
            }
        }
        return mm;
    }

    protected void initializeOpenedMenu(IMenuManager mm) {
        mm.add((IContributionItem)new GroupMarker("wbStart"));
    }
}

