/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.dnd;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simantics.g2d.dnd.IDnDContext;
import org.simantics.g2d.dnd.IDragItem;
import org.simantics.utils.datastructures.context.Context;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;

public class DnDContext
extends Context<IDragItem>
implements IDnDContext {
    IHintContext hintCtx = new HintContext();
    List<IDragItem> orderedItems = new ArrayList<IDragItem>();
    Map<IDragItem, Point2D> itemPositions = new HashMap<IDragItem, Point2D>();

    public DnDContext() {
        super(IDragItem.class);
    }

    @Override
    public IHintContext getHints() {
        return this.hintCtx;
    }

    @Override
    public synchronized void setItemPosition(IDragItem item, Point2D pos) {
        if (item == null) {
            throw new NullPointerException("trying to set position " + pos + " for null IDragItem");
        }
        if (pos == null) {
            throw new NullPointerException("trying to set null position for dragged item " + item);
        }
        this.itemPositions.put(item, pos);
    }

    @Override
    public synchronized Point2D getItemPosition(IDragItem item) {
        return this.itemPositions.get(item);
    }

    public void add(IDragItem item) {
        this.assertNotDisposed();
        this.orderedItems.add(item);
        boolean added = false;
        try {
            super.add((Object)item);
            added = true;
        }
        finally {
            if (!added) {
                this.orderedItems.remove(item);
            }
        }
    }

    public boolean remove(IDragItem item) {
        this.assertNotDisposed();
        boolean existed = super.remove((Object)item);
        if (existed) {
            this.orderedItems.remove(item);
        }
        return existed;
    }

    public void clear() {
        this.assertNotDisposed();
        this.orderedItems.clear();
        super.clear();
    }

    public IDragItem[] toArray() {
        this.assertNotDisposed();
        return this.orderedItems.toArray(new IDragItem[this.orderedItems.size()]);
    }
}

