/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn.lru;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.simantics.acorn.FileCache;
import org.simantics.acorn.FileIO;
import org.simantics.acorn.Persistable;
import org.simantics.acorn.exception.AcornAccessVerificationException;
import org.simantics.acorn.exception.IllegalAcornStateException;
import org.simantics.acorn.lru.AccessTime;
import org.simantics.acorn.lru.LRU;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;

public abstract class LRUObject<MapKey, MapValue extends LRUObject<MapKey, MapValue>>
implements Persistable {
    public static boolean VERIFY = true;
    protected final LRU<MapKey, MapValue> LRU;
    protected final FileCache fileCache;
    private final Semaphore mutex = new Semaphore(1);
    private final MapKey key;
    private final String fileName;
    protected long accessTime = AccessTime.getInstance().getAccessTime();
    private int offset;
    private int length;
    private boolean resident = true;
    private boolean dirty = true;
    private boolean forceResident = false;
    private Path readDirectory;
    private Thread mutexOwner;

    public abstract Logger getLogger();

    public LRUObject(LRU<MapKey, MapValue> LRU2, FileCache fileCache, MapKey key, Path readDirectory, String fileName, int offset, int length, boolean dirty, boolean resident) {
        this.LRU = LRU2;
        this.fileCache = fileCache;
        this.key = key;
        this.fileName = fileName;
        this.offset = offset;
        this.length = length;
        this.readDirectory = readDirectory;
        this.dirty = dirty;
        this.resident = resident;
    }

    public LRUObject(LRU<MapKey, MapValue> LRU2, FileCache fileCache, MapKey key, Path readDirectory, String fileName, boolean dirty, boolean resident) {
        this(LRU2, fileCache, key, readDirectory, fileName, -1, -1, dirty, resident);
    }

    public MapKey getKey() {
        return this.key;
    }

    public void acquireMutex() throws IllegalAcornStateException {
        try {
            while (!this.mutex.tryAcquire(3L, TimeUnit.SECONDS)) {
                this.getLogger().info("Mutex is taking a long time to acquire - owner is " + this.mutexOwner);
            }
            if (VERIFY) {
                this.mutexOwner = Thread.currentThread();
            }
        }
        catch (InterruptedException e) {
            throw new IllegalAcornStateException(e);
        }
    }

    public boolean tryAcquireMutex() {
        return this.mutex.tryAcquire();
    }

    public void releaseMutex() {
        this.mutex.release();
    }

    @Override
    public void toFile(Path bytes) throws IOException {
        if (VERIFY) {
            try {
                this.verifyAccess();
            }
            catch (AcornAccessVerificationException e) {
                throw new IOException("Exception occured during toFile for file " + this.fileName, (Throwable)((Object)e));
            }
        }
        try {
            Pair<byte[], Integer> pair = this.toBytes();
            byte[] data = (byte[])pair.first;
            int length = (Integer)pair.second;
            FileIO fio = this.fileCache.get(bytes);
            int offset = fio.saveBytes(data, length, this.overwrite());
            this.setPosition(offset, length);
        }
        catch (AcornAccessVerificationException | IllegalAcornStateException e) {
            throw new IOException("Exception occured during toFile for file " + this.fileName, (Throwable)e);
        }
    }

    public int makeResident() throws AcornAccessVerificationException, IllegalAcornStateException {
        if (VERIFY) {
            this.verifyAccess();
        }
        return this.LRU.makeResident(this, false);
    }

    public int makeResident(boolean keepResident) throws AcornAccessVerificationException, IllegalAcornStateException {
        if (VERIFY) {
            this.verifyAccess();
        }
        return this.LRU.makeResident(this, true);
    }

    abstract void release();

    abstract String getExtension();

    String getStateKey() throws IllegalAcornStateException, AcornAccessVerificationException {
        String result = String.valueOf(this.getKey().toString()) + "#" + this.getDirectory().getFileName() + "#" + this.getOffset() + "#" + this.getLength();
        if (this.offset == -1) {
            throw new IllegalAcornStateException(result);
        }
        return result;
    }

    long getLastAccessTime() throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        return this.accessTime;
    }

    void accessed() throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        this.accessTime = AccessTime.getInstance().getAccessTime();
    }

    boolean persist() throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        if (this.LRU.persist(this)) {
            this.readDirectory = this.LRU.getDirectory();
            return true;
        }
        return false;
    }

    void setForceResident(boolean value) throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        this.forceResident = value;
    }

    boolean canBePersisted() throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        return !this.forceResident;
    }

    boolean isDirty() throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        return this.dirty;
    }

    boolean isResident() throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        return this.resident;
    }

    String getFileName() throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        return this.fileName;
    }

    void setResident(boolean value) throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        this.resident = value;
    }

    void setDirty(boolean value) throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        this.dirty = value;
    }

    byte[] readFile() throws IOException, AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        Path dir = this.getDirectory();
        Path f = dir.resolve(this.getFileName());
        FileIO fio = this.fileCache.get(f);
        return fio.readBytes(this.getOffset(), this.getLength());
    }

    protected abstract boolean overwrite();

    protected abstract Pair<byte[], Integer> toBytes() throws IllegalAcornStateException;

    protected void setDirty() throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        this.dirty = true;
    }

    protected void verifyAccess() throws AcornAccessVerificationException {
        if (this.mutex.availablePermits() != 0) {
            throw new AcornAccessVerificationException("fileName=" + this.fileName + " mutex has " + this.mutex.availablePermits() + " available permits, should be 0! Current mutexOwner is " + this.mutexOwner);
        }
    }

    protected synchronized void cancelForceResident() throws AcornAccessVerificationException {
        this.setForceResident(false);
    }

    private int getOffset() throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        return this.offset;
    }

    private int getLength() throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        return this.length;
    }

    private void setPosition(int offset, int length) throws AcornAccessVerificationException, IllegalAcornStateException {
        if (VERIFY) {
            this.verifyAccess();
        }
        if (offset == -1) {
            throw new IllegalAcornStateException("offset == -1 for " + this.fileName + " in " + this.readDirectory.toAbsolutePath() + ", dirty=" + this.dirty + ", resident=" + this.resident + ", forceResident=" + this.forceResident);
        }
        this.offset = offset;
        this.length = length;
        if (this.overwrite() && offset > 0) {
            throw new IllegalAcornStateException("overwrite() == true &&  offset > 0 for " + this.fileName + " in " + this.readDirectory.toAbsolutePath() + ", dirty=" + this.dirty + ", resident=" + this.resident + ", forceResident=" + this.forceResident);
        }
    }

    private Path getDirectory() throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        return this.readDirectory;
    }

    public void moveTo(Path path) {
        this.readDirectory = path;
    }
}

