/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.simantics.acorn.internal.AcornDatabase;
import org.simantics.db.Database;
import org.simantics.db.server.ProCoreException;

public class AcornDatabaseManager {
    private static Map<String, Database> dbs = new HashMap<String, Database>();

    public static synchronized Database getDatabase(Path folder) throws ProCoreException {
        Path canonical;
        try {
            Files.createDirectories(folder, new FileAttribute[0]);
            canonical = folder.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new ProCoreException("Could not get canonical path.", (Throwable)e);
        }
        String canonicalPath = canonical.toString();
        Database db = dbs.get(canonicalPath);
        if (db != null) {
            return db;
        }
        db = new AcornDatabase(canonical);
        dbs.put(canonicalPath, db);
        return db;
    }
}

