/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.xml;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Node
implements Iterable<Node> {
    public static final short ELEMENT_NODE = 1;
    public static final short ATTRIBUTE_NODE = 2;
    public static final short TEXT_NODE = 3;
    public static final short CDATA_SECTION_NODE = 4;
    public static final short ENTITY_REFERENCE_NODE = 5;
    public static final short ENTITY_NODE = 6;
    public static final short PROCESSING_INSTRUCTION_NODE = 7;
    public static final short COMMENT_NODE = 8;
    public static final short DOCUMENT_NODE = 9;
    public static final short DOCUMENT_TYPE_NODE = 10;
    public static final short DOCUMENT_FRAGMENT_NODE = 11;
    public static final short NOTATION_NODE = 12;
    private org.w3c.dom.Node node;

    public Node(org.w3c.dom.Node node) {
        this.node = node;
    }

    public Node(File file) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.node = builder.parse(file);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Iterator<Node> iterator() {
        return new NodeIterator(this.node.getChildNodes());
    }

    public String name() {
        return this.node.getNodeName();
    }

    public String value() {
        return this.node.getNodeValue().trim();
    }

    public int type() {
        return this.node.getNodeType();
    }

    public Node parent() {
        return new Node(this.node.getParentNode());
    }

    public Node get(String key) {
        return new Node(this.node.getAttributes().getNamedItem(key));
    }

    public String getValue(String key) {
        return this.node.getAttributes().getNamedItem(key).getNodeValue().trim();
    }

    public int childCount() {
        return this.node.getChildNodes().getLength();
    }

    public String text() {
        return this.node.getTextContent().trim();
    }

    public Node getSingleChild(String type) {
        NodeList nodeList = this.node.getChildNodes();
        Node child = null;
        int i = 0;
        while (i < nodeList.getLength()) {
            org.w3c.dom.Node c = nodeList.item(i);
            if (c.getNodeName().equals(type)) {
                if (child == null) {
                    child = new Node(c);
                } else {
                    System.out.println("Child of type " + type + " is not unique.");
                }
            }
            ++i;
        }
        return child;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Node && this.node.equals(((Node)obj).node);
    }

    static class NodeIterator
    implements Iterator<Node> {
        NodeList list;
        int i;
        int length;

        public NodeIterator(NodeList list) {
            this.list = list;
            this.i = 0;
            this.length = list.getLength();
        }

        @Override
        public boolean hasNext() {
            return this.i < this.length;
        }

        @Override
        public Node next() {
            return new Node(this.list.item(this.i++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

