/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.compiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.Locale;
import java.util.TreeMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Files;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.graph.compiler.CompilationResult;
import org.simantics.graph.compiler.ExternalFileLoader;
import org.simantics.graph.compiler.GraphCompilerPreferences;
import org.simantics.graph.compiler.internal.ltk.FileSource;
import org.simantics.graph.compiler.internal.ltk.ISource;
import org.simantics.graph.compiler.internal.ltk.Location;
import org.simantics.graph.compiler.internal.ltk.Problem;
import org.simantics.graph.compiler.internal.parsing.Parsing;
import org.simantics.graph.compiler.internal.procedures.AddConsistsOf;
import org.simantics.graph.compiler.internal.procedures.ApplyTemplates;
import org.simantics.graph.compiler.internal.procedures.Compactify;
import org.simantics.graph.compiler.internal.procedures.ConvertPreValues;
import org.simantics.graph.compiler.internal.procedures.CreateInverseRelations;
import org.simantics.graph.compiler.internal.procedures.CreateTemplates;
import org.simantics.graph.compiler.internal.procedures.DefaultValueTyping;
import org.simantics.graph.compiler.internal.procedures.MergeEqualResources;
import org.simantics.graph.compiler.internal.procedures.PropagateNewMarks;
import org.simantics.graph.compiler.internal.resourceFiles.ResourceFileGenerator;
import org.simantics.graph.compiler.internal.store.LocationStore;
import org.simantics.graph.compiler.internal.store.VariableStore;
import org.simantics.graph.compiler.internal.validation.ReportCollisions;
import org.simantics.graph.compiler.internal.validation.ValidateGraph;
import org.simantics.graph.query.IGraph;
import org.simantics.graph.query.Paths;
import org.simantics.graph.query.TransferableGraphConversion;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.store.GraphStore;

public class GraphCompiler {
    public static PrintStream out = System.out;

    public static TransferableGraph1 read(File file) throws Exception {
        DataContainer container = DataContainers.readFile((File)file);
        return (TransferableGraph1)container.content.getValue(TransferableGraph1.BINDING);
    }

    public static TransferableGraph1 read(InputStream stream) throws AdaptException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream in = stream;){
            DataContainer container = DataContainers.readFile((DataInput)new DataInputStream(stream));
            return (TransferableGraph1)container.content.getValue(TransferableGraph1.BINDING);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static InputStream write(TransferableGraph1 tg) throws BindingException, IOException {
        Binding binding = TransferableGraph1.BINDING;
        int hashCode = binding.hashValue((Object)tg);
        TreeMap<String, Variant> metadata = new TreeMap<String, Variant>();
        metadata.put("cached.hashcode", new Variant((Binding)Bindings.INTEGER, (Object)hashCode));
        byte[] buffer = DataContainers.writeFile((DataContainer)new DataContainer("graph", 1, metadata, new Variant(binding, (Object)tg)));
        return new ByteArrayInputStream(buffer);
    }

    public static void write(File file, TransferableGraph1 tg) throws BindingException, IOException {
        Binding binding = TransferableGraph1.BINDING;
        int hashCode = binding.hashValue((Object)tg);
        TreeMap<String, Variant> metadata = new TreeMap<String, Variant>();
        metadata.put("cached.hashcode", new Variant((Binding)Bindings.INTEGER, (Object)hashCode));
        DataContainers.writeFile((File)file, (DataContainer)new DataContainer("graph", 1, metadata, new Variant(binding, (Object)tg)));
    }

    /*
     * Unable to fully structure code
     */
    public static CompilationResult compile(String Layer0Version, Collection<ISource> sources, Collection<TransferableGraph1> dependencies, ExternalFileLoader fileLoader, GraphCompilerPreferences preferences) {
        block11: {
            errors = new ArrayList<Problem>();
            store = new GraphStore();
            compilationResult = new CompilationResult();
            compilationResult.errors = errors;
            compilationResult.warnings = new ArrayList<Problem>();
            paths = new Paths(Layer0Version);
            try {
                GraphCompiler.run(new Parsing(paths, sources, errors, store));
                if (!errors.isEmpty()) {
                    return compilationResult;
                }
                beginTime = System.nanoTime();
                graph = TransferableGraphConversion.convert((Paths)paths, dependencies);
                graph.addFragment(store);
                endTime = System.nanoTime();
                GraphCompiler.reportTime("Composition", beginTime, endTime);
                GraphCompiler.run(new MergeEqualResources(paths, store));
                unfoundedIdentitities = store.identities.getUnfoundedIdentities();
                if (unfoundedIdentitities.length > 0) {
                    locations = (LocationStore)store.getStore(LocationStore.class);
                    var15_26 = unfoundedIdentitities;
                    var14_27 = unfoundedIdentitities.length;
                    var13_28 = 0;
                    while (var13_28 < var14_27) {
                        id = var15_26[var13_28];
                        errors.add(new Problem(locations.getLocation(id), "URIless resource used as a parent."));
                        ++var13_28;
                    }
                    return compilationResult;
                }
                store.identities.createPathToId(paths.ConsistsOf);
                GraphCompiler.run(new CreateTemplates(graph, store, errors));
                GraphCompiler.run(new ApplyTemplates((IGraph)graph, store, errors, fileLoader));
                GraphCompiler.run(new DefaultValueTyping(paths, store));
                GraphCompiler.run(new Compactify(store));
                GraphCompiler.run(new PropagateNewMarks(store));
                GraphCompiler.run(new CreateInverseRelations((IGraph)graph, store));
                GraphCompiler.run(new AddConsistsOf(paths, store));
                GraphCompiler.run(new ConvertPreValues((IGraph)graph, store, errors));
                GraphCompiler.run(new ReportCollisions(preferences, errors, store));
                if (preferences.validate) {
                    GraphCompiler.run(new ValidateGraph(graph, errors, store, preferences));
                }
                beginTime = System.nanoTime();
                compilationResult.graph = TransferableGraphConversion.convert((IGraph)graph, (GraphStore)store);
                endTime = System.nanoTime();
                GraphCompiler.reportTime("Generate TG", beginTime, endTime);
                beginTime = System.nanoTime();
                compilationResult.resourceFiles = ResourceFileGenerator.generate(paths, store);
                endTime = System.nanoTime();
                GraphCompiler.reportTime("Generate resources", beginTime, endTime);
                variableStore = (VariableStore)store.getStore(VariableStore.class);
                compilationResult.sourceInfo = variableStore.getSourceInfo();
                for (Problem problem : compilationResult.errors) {
                    if (problem.getLocation() == null) {
                        var13_29 = sources.iterator();
                        if (!var13_29.hasNext()) continue;
                        source = var13_29.next();
                        problem.setLocation(new Location(source));
                        continue;
                    }
                    if (problem.getLocation().getSource() != null || !(var13_29 = sources.iterator()).hasNext()) continue;
                    source = var13_29.next();
                    problem.getLocation().setSource(source);
                }
                for (Problem problem : compilationResult.warnings) {
                    if (problem.getLocation() == null) {
                        var13_29 = sources.iterator();
                        if (!var13_29.hasNext()) continue;
                        source = var13_29.next();
                        problem.setLocation(new Location(source));
                        continue;
                    }
                    if (problem.getLocation().getSource() != null || !(var13_29 = sources.iterator()).hasNext()) continue;
                    source = var13_29.next();
                    problem.getLocation().setSource(source);
                }
                break block11;
            }
            catch (Exception e) {
                e.printStackTrace();
                stream = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(stream));
                description = "Internal error: " + new String(stream.toByteArray());
                ** for (source : sources)
            }
lbl-1000:
            // 1 sources

            {
                errors.add(new Problem(new Location(source), description));
                continue;
            }
        }
        return compilationResult;
    }

    private static void run(Runnable runnable) {
        runnable.run();
    }

    public static void reportTime(String taskName, long beginTime, long endTime) {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format("%-25s %8.4f ms", taskName, (double)(endTime - beginTime) * 1.0E-6);
        out.println(sb.toString());
    }

    public static void reportTime(String taskName, long beginTime) {
        GraphCompiler.reportTime(taskName, beginTime, System.nanoTime());
    }

    public static void main(String[] args) {
        ArrayList<ISource> sources = new ArrayList<ISource>();
        ArrayList<TransferableGraph1> dependencies = new ArrayList<TransferableGraph1>();
        String outputFile = null;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equals("-o")) {
                if (++i < args.length) {
                    outputFile = args[i];
                }
            } else if (arg.endsWith(".tg")) {
                try {
                    dependencies.add(GraphCompiler.read(new File(arg)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            } else if (arg.endsWith(".graph") || arg.endsWith(".pgraph")) {
                sources.add(new FileSource(arg));
            } else {
                System.err.println("Invalid input file extension " + arg);
                return;
            }
            ++i;
        }
        if (sources.isEmpty()) {
            System.err.println("No source files");
            return;
        }
        if (outputFile == null) {
            System.err.println("Name of the output file is not given (use -o flag).");
            return;
        }
        CompilationResult result = GraphCompiler.compile("1.0", sources, dependencies, null, new GraphCompilerPreferences());
        for (Problem problem : result.getErrors()) {
            out.println(problem.getLocation() + ": " + problem.getDescription());
        }
        if (result.getGraph() != null) {
            try {
                Files.createFile((File)new File(outputFile), (Binding)TransferableGraph1.BINDING, (Object)result.getGraph());
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

