package org.simantics.scl.ui.modulebrowser;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.simantics.scl.compiler.module.repository.ModuleRepository;

public class SCLModuleTree extends TreeViewer {
    
    private LabelProvider labelProvider = new SCLModuleTreeLabelProvider();
    private SCLModuleTreeContentProvider contentProvider;
    
    public SCLModuleTree(Composite parent, int style, ModuleRepository repository) {
        super(parent, style);
        this.contentProvider = new SCLModuleTreeContentProvider();
        setUseHashlookup(true);
        setLabelProvider(labelProvider);
        setContentProvider(contentProvider);
        setAutoExpandLevel(1);
        setInput(repository);
    }

    public void recalculateInput() {
        contentProvider.update();
        refresh();
    }

}
