/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.util;

import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.annotations.Referable;

public class WeightedMedian {
    public int maxItems;
    public int itemCount;
    @Optional
    public Item median;
    public double rpos;

    public WeightedMedian() {
        this.maxItems = Integer.MAX_VALUE;
    }

    public WeightedMedian(int maxItems) {
        this.maxItems = maxItems;
    }

    public void clear() {
        this.itemCount = 0;
        this.median = null;
        this.rpos = 0.0;
    }

    public void add(double weight, double value) {
        if (weight <= 0.0) {
            return;
        }
        if (this.median == null) {
            this.median = new Item(weight, value);
            ++this.itemCount;
            this.rpos = weight / 2.0;
            return;
        }
        Item i = this.median;
        while (true) {
            Item n;
            if (i.value == value) {
                i.weight += weight;
                break;
            }
            if (value < i.value) {
                if (i.prev == null) {
                    i.prev = new Item(weight, value, null, i);
                    ++this.itemCount;
                    break;
                }
                if (i.prev.value < value) {
                    n = new Item(weight, value, i.prev, i);
                    ++this.itemCount;
                    i.prev.next = n;
                    i.prev = n;
                    break;
                }
                i = i.prev;
                continue;
            }
            if (!(value > i.value)) continue;
            if (i.next == null) {
                i.next = new Item(weight, value, i, null);
                ++this.itemCount;
                break;
            }
            if (i.next.value > value) {
                n = new Item(weight, value, i, i.next);
                ++this.itemCount;
                i.next.prev = n;
                i.next = n;
                break;
            }
            i = i.next;
        }
        this.rpos += (double)(value < this.median.value ? -1 : 1) * weight / 2.0;
        while (this.rpos < 0.0) {
            this.median = this.median.prev;
            this.rpos += this.median.weight;
        }
        while (this.rpos >= this.median.weight) {
            this.rpos -= this.median.weight;
            this.median = this.median.next;
        }
        if (this.itemCount > this.maxItems) {
            this.coalesce();
        }
    }

    public void coalesce() {
        this.coalesceVerySimple();
    }

    public void coalesceVerySimple() {
        double totWeight;
        Item mergeToItem;
        Item itemToMerge;
        Item i = this.median.next;
        while (i != null) {
            Item n = i.next;
            if (n == null) break;
            i.next = n.next;
            if (n.next != null) {
                n.next.prev = i;
            }
            itemToMerge = n.weight > i.weight ? n : i;
            mergeToItem = n.weight > i.weight ? i : n;
            mergeToItem.weight = totWeight = mergeToItem.weight + itemToMerge.weight;
            i = i.next;
        }
        i = this.median.prev;
        while (i != null) {
            Item p = i.prev;
            if (p == null) break;
            i.prev = p.prev;
            if (p.prev != null) {
                p.prev.next = i;
            }
            itemToMerge = p.weight > i.weight ? p : i;
            mergeToItem = p.weight > i.weight ? p : i;
            mergeToItem.weight = totWeight = mergeToItem.weight + itemToMerge.weight;
            i.weight = totWeight;
            i = i.prev;
        }
    }

    public double getMedian() {
        if (this.median == null) {
            return Double.NaN;
        }
        return this.median.value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Median=" + this.getMedian() + " ");
        Item i = this.head();
        while (i != null) {
            if (i == this.median) {
                sb.append("(value=" + i.value + ", w=" + i.weight + ", pos=" + this.rpos + ")");
            } else {
                sb.append("(value=" + i.value + ", w=" + i.weight + ")");
            }
            i = i.next;
        }
        return sb.toString();
    }

    Item head() {
        if (this.median == null) {
            return null;
        }
        Item i = this.median;
        while (i.prev != null) {
            i = i.prev;
        }
        return i;
    }

    @Referable
    public static class Item {
        public double weight;
        public double value;
        @Optional
        public Item prev;
        @Optional
        public Item next;

        public Item(double weight, double value) {
            this.weight = weight;
            this.value = value;
        }

        public Item(double weight, double value, Item prev, Item next) {
            this.weight = weight;
            this.value = value;
            this.prev = prev;
            this.next = next;
        }

        public String toString() {
            return "(value=" + this.value + ", w=" + this.weight + ")";
        }
    }
}

