/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "fastlz.h"

#define BLOCKSIZE (128*1024)

char* uncompressed;
int uncompressedCapacity;
int position;
char* compressed;
int compressedCapacity;

FILE* handle;

void initWrite(FILE* _handle) {
    uncompressedCapacity = BLOCKSIZE;
    uncompressed = malloc(uncompressedCapacity);
    position = 0;
    compressedCapacity = 8 + BLOCKSIZE + (BLOCKSIZE/20);
    compressed = malloc(compressedCapacity);
    handle = _handle;
}

void flushBuffer() {
    int uncompressedSize = position;
    int compressedSize = fastlz_compress(uncompressed, uncompressedSize, compressed+8);

    ((int*)compressed)[0] = compressedSize;
    ((int*)compressed)[1] = uncompressedSize;
    
    fwrite(compressed, compressedSize+8, 1, handle);
    position = 0;
}

void deinitWrite() {
    flushBuffer();

    ((int*)compressed)[0] = 0;
    ((int*)compressed)[1] = 0;    
    fwrite(compressed, 8, 1, handle);

    free(uncompressed);
    uncompressed = 0;
    free(compressed);
    compressed = 0;
    handle = 0;
}

void write(char* data, int offset, int length) {
    int s;

    while(length > uncompressedCapacity - position) {
        s = uncompressedCapacity - position;
        memcpy(uncompressed + position, data + offset, s);
        offset += s;
        length -= s;
        position += s;
        flushBuffer();
    }
    memcpy(uncompressed + position, data + offset, length);
    position += length;
}
