/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.event.view.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.event.ontology.EventResource;
import org.simantics.layer0.Layer0;

/**
 * Given a list of events, return respective eventlogs.
 */
public class GetEventLogsQuery extends UniqueRead<Collection<Resource>> {

	Collection<Resource> events;
	
	public GetEventLogsQuery(Collection<Resource> events) {
		this.events = events;
	}

	@Override
	public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
		Layer0 L0 = Layer0.getInstance(graph);
		EventResource EVENT = EventResource.getInstance(graph);
		List<Resource> eventlogs = new ArrayList<Resource>(1);
		for (Resource event : events) {
			Resource eventslice = graph.getPossibleObject(event, L0.PartOf);
			if (eventslice==null || !graph.isInstanceOf(eventslice, EVENT.EventSlice)) continue;
			Resource eventlog = graph.getPossibleObject(eventslice, L0.PartOf);
			if (eventlog==null || !graph.isInstanceOf(eventlog, EVENT.EventLog)) continue;
			if (!eventlogs.contains( event )) {
				eventlogs.add( eventlog );
			}
		}
		return eventlogs;
	}
	

}
