/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.preference;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.Preferences;
import org.simantics.charts.Activator;

/**
 * @author Toni Kalajainen
 */
public class ChartPreferenceInitializer extends AbstractPreferenceInitializer {

    public void initializeDefaultPreferences() {
        IScopeContext context = DefaultScope.INSTANCE;
        Preferences node = context.getNode(Activator.PLUGIN_ID);

        node.putLong(ChartPreferences.P_REDRAW_INTERVAL, ChartPreferences.DEFAULT_REDRAW_INTERVAL);
        node.putLong(ChartPreferences.P_AUTOSCALE_INTERVAL, ChartPreferences.DEFAULT_AUTOSCALE_INTERVAL);
        node.putBoolean(ChartPreferences.P_DRAW_SAMPLES, ChartPreferences.DEFAULT_DRAW_SAMPLES);
        node.put(ChartPreferences.P_TIMEFORMAT, ChartPreferences.DEFAULT_TIMEFORMAT);
        node.put(ChartPreferences.P_VALUEFORMAT, ChartPreferences.DEFAULT_VALUEFORMAT);
        node.put(ChartPreferences.P_TIMEWINDOW_TEMPLATE, ChartPreferences.DEFAULT_TIMEWINDOW_TEMPLATE);
        node.put(ChartPreferences.P_DRAWMODE, ChartPreferences.DEFAULT_DRAWMODE);
        node.put(ChartPreferences.P_AXISMODE, ChartPreferences.DEFAULT_AXISMODE);
        node.put(ChartPreferences.P_SCALEMODE, ChartPreferences.DEFAULT_SCALEMODE);
        node.put(ChartPreferences.P_ITEMPLACEMENT, ChartPreferences.DEFAULT_ITEMPLACEMENT);
    }

}
