package org.simantics.charts.editor;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.dialogs.PreferencesUtil;

/**
 * @author Tuukka Lehtonen
 */
public class ChartPreferencesAction extends Action {

	private static final String CHART_DEFAULTS_PREF_PAGE_ID = "org.simantics.charts.defaults"; //$NON-NLS-1$
	private static final String CHART_PREF_PAGE_ID = "org.simantics.charts.pref"; //$NON-NLS-1$
	private static final String CSV_PREF_PAGE_ID = "org.simantics.modeling.csv.preferences"; //$NON-NLS-1$ 

	private IShellProvider shell;

	public ChartPreferencesAction(IShellProvider shell) {
		super(Messages.ChartPreferencesAction_ChartPreferences);
		this.shell = shell;
	}

	@Override
	public void run() {
		PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(
				shell.getShell(),
				CHART_PREF_PAGE_ID,
				new String[] {
						CHART_PREF_PAGE_ID,
						CHART_DEFAULTS_PREF_PAGE_ID,
						CSV_PREF_PAGE_ID
				},
				null);
		dialog.open();
	}

}