/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;

public class WidgetSupportImpl implements WidgetSupport {

	final protected CopyOnWriteArrayList<Widget> widgets = new CopyOnWriteArrayList<Widget>();
	final protected Map<String, Object> parameters = new HashMap<String, Object>();
	protected Object lastInput = NO_INPUT;
	protected ISessionContext lastContext = null;
	private boolean finished = false;

	final protected List<Listener<?>> listeners = new CopyOnWriteArrayList<Listener<?>>();
	
	@Override
	public synchronized void register(Widget widget) {
		widgets.add(widget);
	}
	
	@Override
	public void update(Widget widget) {
		if(lastContext != null && lastInput != NO_INPUT) widget.setInput(lastContext, lastInput);
	}

	@Override
	public void update() {
		for(Widget widget : widgets) update(widget);
	}
	
	@Override
	public void finish() {
		finished = true;
		//for(Widget widget : widgets) update(widget);
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public <T> T getInput() {
		return (T) lastInput;
	}
	
	public void fireInput(ISessionContext context, Object input) {
		
		lastInput = input;
		lastContext = context;
		
		for(Widget widget : widgets) {
			widget.setInput(context, input);
			for (Listener listener : listeners)
				listener.execute(input);
		}
		
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public <T> T getParameter(String key) {
		return (T) parameters.get(key);
	}
	
	@Override
	public void setParameter(String key, Object value) {
		parameters.put(key, value);
	}

	@Override
	public <T> T getInput(ReadGraph graph) throws DatabaseException {
		return graph.sync(new ParametrizedPrimitiveRead<WidgetSupport, T>(this) {

			Listener<T> procedure;

			@SuppressWarnings("unchecked")
			@Override
			public void register(ReadGraph graph, Listener<T> procedure) {
				synchronized (listeners) {
					if(listeners.contains(procedure))
						return;
					this.procedure = procedure;
					listeners.add(procedure);
					procedure.execute((T)lastInput);
				}
			}

			@Override
			public void unregistered() {
				synchronized (listeners) {
					listeners.remove(procedure);
					procedure = null;
				}
			}

		});
	}
	
}
