/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.viewers.ISelection;
import org.simantics.db.management.ISessionContext;
import org.simantics.utils.ui.ISelectionUtils;

public class SingleSelectionInputSource extends InputSourceImpl<Object> {

	public SingleSelectionInputSource(Class<?> clazz) {
		super(clazz);
	}
	
	@Override
	public Object get(ISessionContext ctx, Object selection) {
		return ISelectionUtils.filterSingleSelection((ISelection)selection, clazz);
	}

}
