/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.viewers.IFilter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.simantics.browsing.ui.Column;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;

/**
 * @author Tuukka Lehtonen
 */
public class SingleClickStartEditMouseListener extends MouseAdapter {

    public static final IFilter BUTTON1_FIRST_DOWN_FILTER = new IFilter() {
        @Override
        public boolean select(Object toTest) {
            MouseEvent e = (MouseEvent) toTest;
            return e.button == 1 && e.count == 1;
        }
    }; 

    private GraphExplorer explorer;
    private IFilter       eventFilter;
    private Tree          tree;
    private Column[]      columns;

    public static SingleClickStartEditMouseListener attachWithSingleLeftDown(GraphExplorer explorer) {
        return attachTo(explorer, BUTTON1_FIRST_DOWN_FILTER);
    }

    public static SingleClickStartEditMouseListener attachTo(GraphExplorer explorer, IFilter eventFilter) {
        SingleClickStartEditMouseListener l = new SingleClickStartEditMouseListener(explorer, eventFilter);
        explorer.addListener(l);
        return l;
    }

    public SingleClickStartEditMouseListener(GraphExplorer explorer, IFilter eventFilter) {
        if (explorer == null)
            throw new NullPointerException("null explorer");

        this.explorer = explorer;
        this.eventFilter = eventFilter;
        this.tree = (Tree) explorer.getControl();
        this.columns = explorer.getColumns();
    }

    @Override
    public void mouseDown(MouseEvent e) {
        if (eventFilter != null && !eventFilter.select(e))
            return;

        Point point = new Point(e.x, e.y);
        TreeItem item = tree.getItem(point);
        if (item == null)
            return;

        NodeContext ctx = (NodeContext) item.getData();
        if (ctx == null)
            return;

        int columnCount = tree.getColumnCount();
        for (int i = 0; i < columnCount && i < columns.length; i++) {
            if (!item.isDisposed() && item.getBounds(i).contains(point)) {
                explorer.startEditing(ctx, columns[i].getKey());
            }
        }
    }

}