/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.simantics.browsing.ui.content.Imager;
import org.simantics.utils.datastructures.cache.IMapProvider;
import org.simantics.utils.datastructures.cache.ProvisionException;
import org.simantics.utils.ui.ErrorLogger;

/**
 * @author Tuukka Lehtonen
 */
public class ProviderImager<ImageDescriptor> implements Imager {

    private final IMapProvider<String, ImageDescriptor> provider;

    public ProviderImager(IMapProvider<String, ImageDescriptor> constants) {
        this.provider = constants;
    }

    @SuppressWarnings("unchecked")
    @Override
    public ImageDescriptor getImage(String key) {
        try {
            return provider.get(key);
        } catch (ProvisionException e) {
            ErrorLogger.defaultLogError(e);
            return null;
        }
    }

}
