/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.util.HashMap;
import java.util.function.Consumer;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.BuiltinKeys.ImagerKey;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.EvaluatorData.Transformer;
import org.simantics.browsing.ui.common.imagers.ContainerImager;
import org.simantics.browsing.ui.content.Imager;
import org.simantics.browsing.ui.content.ImagerFactory;
import org.simantics.browsing.ui.graph.impl.MissingImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.icons.ImageUtil;
import org.simantics.utils.datastructures.cache.ProvisionException;
import org.simantics.utils.ui.ErrorLogger;

/**
 * @deprecated favor {@link AdapterImagerFactory} instead
 */
@Deprecated
public class OldAdapterImagerFactory implements ImagerFactory {

    private final Transformer transformer;
    private final HashMap<String, ImageDescriptor> constants;
    private final String resourceColumn;

    public OldAdapterImagerFactory() {
        this(null);
    }

    public OldAdapterImagerFactory(Transformer transformer) {
        this(transformer, null, new HashMap<String, ImageDescriptor>(4));
    }

    public OldAdapterImagerFactory(Transformer transformer,
            String resourceColumn, HashMap<String, ImageDescriptor> constants) {
        this.transformer = transformer;
        this.constants = constants;
        this.resourceColumn = resourceColumn;
    }

    private Resource getInputResource(final NodeContext context) {
        Object input = context.getConstant(BuiltinKeys.INPUT);
        if (transformer != null) {
            input = transformer.transform(input);
        }

        if (input instanceof Resource)
            return (Resource) input;
        else if (input instanceof IAdaptable)
            return (Resource) (((IAdaptable) input).getAdapter(Resource.class));
        return null;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Imager create(final PrimitiveQueryUpdater updater, final NodeContext context, final ImagerKey key) {
        @SuppressWarnings("rawtypes")
        final ContainerImager result = new ContainerImager((HashMap<String, ImageDescriptor>) constants.clone());
        result.setImage(resourceColumn, MissingImageDescriptor.getInstance());

        final DataSource<ReadGraph> source = updater.getDataSource(ReadGraph.class);
        final Resource inputResource = getInputResource(context);

        source.schedule(new Consumer<ReadGraph>() {
            @Override
            public void accept(ReadGraph source) {
                try {
                    ImageDescriptor descriptor = ImageUtil.adaptImageDescriptor(source, inputResource);
                    result.setImage(resourceColumn, descriptor);
                    updater.scheduleReplace(context, key, result);
                } catch (ProvisionException e) {
                    ErrorLogger.defaultLogError(e);
                } catch (DatabaseException e) {
                    ErrorLogger.defaultLogError(e);
                }
            }
        });

        return result;
    }

}
