/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.maps.server;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.simantics.district.maps.server.Activator;
import org.simantics.district.maps.server.TileserverMapnik;
import org.simantics.district.maps.server.TileserverMapnikInstance;
import org.simantics.district.maps.server.utils.EnvUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.stream.slf4j.Slf4jInfoOutputStream;

public class NodeJS {
    public static final String NODEJS_VERSION = "v4.8.0";
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeJS.class);
    private static final String NODE = "node";

    private static Path nodeJSFolder() throws IOException, URISyntaxException {
        StringBuilder sb = new StringBuilder();
        sb.append(NODE).append("-").append(NODEJS_VERSION).append("-").append(NodeJS.getOs()).append("-").append(NodeJS.getArch());
        return Activator.getNodeJSRoot().resolve(sb.toString());
    }

    public static Path executable() throws IOException, URISyntaxException {
        String nodeJSexecutable = NODE;
        if (EnvUtil.calculateOS() == "win") {
            nodeJSexecutable = String.valueOf(nodeJSexecutable) + ".exe";
        }
        return NodeJS.nodeJSFolder().resolve(nodeJSexecutable).toAbsolutePath().normalize();
    }

    private static Path npmExecutable() throws IOException, URISyntaxException {
        String npmExecutable = "npm";
        if (EnvUtil.calculateOS() == "win") {
            npmExecutable = String.valueOf(npmExecutable) + ".cmd";
        }
        return NodeJS.nodeJSFolder().resolve(npmExecutable).toAbsolutePath().normalize();
    }

    private static String getArch() {
        return EnvUtil.calculateArch();
    }

    private static String getOs() {
        return EnvUtil.calculateOS();
    }

    public static int npm(OutputStream output, String ... args) throws InvalidExitValueException, IOException, InterruptedException, TimeoutException, URISyntaxException {
        LOGGER.info("Executing npm with args {}", (Object)Arrays.toString(args));
        ArrayList<String> actualArgs = new ArrayList<String>();
        actualArgs.add(NodeJS.npmExecutable().toString());
        actualArgs.addAll(Arrays.asList(args));
        ProcessExecutor exec = new ProcessExecutor().command(actualArgs).redirectOutput((OutputStream)new Slf4jInfoOutputStream(LOGGER){

            protected void processLine(String line) {
                String utf8Line = new String(line.getBytes(), StandardCharsets.UTF_8);
                this.log.info(utf8Line);
            }
        }).destroyOnExit();
        if (output != null) {
            exec.redirectOutputAlsoTo(output);
        }
        return exec.execute().getExitValue();
    }

    public static void main(String[] args) throws Exception {
        TileserverMapnik server = TileserverMapnikInstance.get();
        server.start(Optional.empty());
    }
}

