/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.route.ui.actions;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.swt.widgets.Display;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Read;
import org.simantics.district.network.ui.DistrictNetworkUIUtil;
import org.simantics.district.route.Route;
import org.simantics.district.route.RouteJob;
import org.simantics.district.route.RouterConfiguration;
import org.simantics.district.route.internal.RoutePersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectRouteAction
implements ActionFactory {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SelectRouteAction.class);

    public Runnable create(final Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        return new Runnable(){

            @Override
            public void run() {
                try {
                    Route route = (Route)Simantics.getSession().syncRequest((Read)new RoutePersistence.RouteRequest((Resource)target));
                    if (route == null) {
                        LOGGER.error("Reading a route object failed");
                        return;
                    }
                    CompletableFuture result = new CompletableFuture();
                    ((CompletableFuture)result.exceptionally(e -> Collections.emptyList())).thenAccept(dnElements -> {
                        if (!dnElements.isEmpty()) {
                            try {
                                Display display = Display.getDefault();
                                if (display != null) {
                                    DistrictNetworkUIUtil.openDNDiagramWithSelection((Display)display, (List)dnElements);
                                } else {
                                    LOGGER.error("No display found");
                                }
                            }
                            catch (DatabaseException e) {
                                LOGGER.error("Failed to open district network diagram with selection " + dnElements, (Throwable)e);
                            }
                        }
                    });
                    RouterConfiguration config = new RouterConfiguration();
                    new RouteJob(config, route, result).schedule();
                }
                catch (DatabaseException e2) {
                    LOGGER.error("Error in selecting route " + target, (Throwable)e2);
                }
            }
        };
    }
}

