/*
 * Decompiled with CFR 0.152.
 */
package org.simantics;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.WriteBindings;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.db.AbstractImportAdvisor2;
import org.simantics.graph.db.TransferableGraphImporter;
import org.simantics.graph.representation.Root;
import org.simantics.layer0.Layer0;
import org.simantics.project.management.DatabaseManagement;
import org.simantics.project.management.GraphBundle;

public class OntologyImportAdvisor
extends AbstractImportAdvisor2 {
    private final GraphBundle tg;
    private final DatabaseManagement mgmt;
    private final String rootName;
    private Resource ontology;
    private Resource ontologyName;

    public OntologyImportAdvisor(GraphBundle tg, DatabaseManagement mgmt) {
        this.tg = tg;
        this.mgmt = mgmt;
        this.rootName = tg.getName().contains("@") ? tg.getName().substring(tg.getName().lastIndexOf("/") + 1) : String.valueOf(tg.getName().substring(tg.getName().lastIndexOf("/") + 1)) + "-" + tg.getMajor() + "." + tg.getMinor();
    }

    public Resource getTarget() {
        return null;
    }

    public Resource analyzeRoot(ReadGraph graph, Root root) throws DatabaseException {
        return null;
    }

    public Resource createRoot(WriteOnlyGraph graph, Root root) throws DatabaseException {
        return this.createRoot(graph, root, null);
    }

    public Resource createRoot(WriteOnlyGraph graph, Root root, Resource resource) throws DatabaseException {
        if (resource == null) {
            resource = graph.newResource();
        }
        this.addRootInfo(root, root.name, resource);
        return resource;
    }

    public void beforeWrite(WriteOnlyGraph graph, TransferableGraphImporter process) throws DatabaseException {
        this.ontology = graph.newResource(graph.getRootLibrary());
        this.ontologyName = graph.newResource(graph.getRootLibrary());
        graph.newClusterSet(this.ontology);
        graph.setClusterSet4NewResource(this.ontology);
    }

    public void afterWrite(WriteOnlyGraph graph, TransferableGraphImporter process) throws DatabaseException {
        try {
            long[] ids = process.getResourceIds((SerialisationSupport)graph.getService(SerialisationSupport.class));
            this.tg.setResourceArray(ids);
            this.mgmt.createGraphBundle(graph, this.tg);
        }
        catch (DatabaseException e) {
            throw new RuntimeDatabaseException((Throwable)e);
        }
    }

    public boolean allowImmutableModifications() {
        return true;
    }

    public Resource createChild(WriteOnlyGraph graph, TransferableGraphImporter process, Resource parent, String name) throws DatabaseException {
        if (this.rootName.equals(name)) {
            Layer0 L0 = (Layer0)graph.getService(Layer0.class);
            graph.claim(this.ontologyName, L0.InstanceOf, null, L0.String);
            graph.claimValue(this.ontologyName, (Object)name, WriteBindings.STRING);
            graph.claim(this.ontology, L0.HasName, L0.NameOf, this.ontologyName);
            return this.ontology;
        }
        return process.createChild(graph, parent, null, name);
    }

    public Resource createChild(WriteOnlyGraph graph, TransferableGraphImporter process, Resource parent, Resource child, String name) throws DatabaseException {
        if (this.rootName.equals(name)) {
            Layer0 L0 = (Layer0)graph.getService(Layer0.class);
            graph.claim(this.ontologyName, L0.InstanceOf, null, L0.String);
            graph.claimValue(this.ontologyName, (Object)name, WriteBindings.STRING);
            graph.claim(this.ontology, L0.HasName, L0.NameOf, this.ontologyName);
            graph.claim(this.ontology, L0.PartOf, L0.ConsistsOf, parent);
            return this.ontology;
        }
        return process.createChild(graph, parent, null, name);
    }
}

