/*
 * Decompiled with CFR 0.152.
 */
package org.simantics;

import org.simantics.NameLabelMode;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.Versions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.layer0.Layer0;
import org.simantics.platform.ui.PlatformUIResource;

public class NameLabelUtil {
    public static NameLabelMode getNameLabelMode(RequestProcessor processor) {
        try {
            Resource project = Simantics.getProjectResource();
            return (NameLabelMode)((Object)processor.syncRequest((Read)new ResourceRead<NameLabelMode>(project){

                public NameLabelMode perform(ReadGraph graph) throws DatabaseException {
                    PlatformUIResource UI = PlatformUIResource.getInstance((ReadGraph)graph);
                    String value = (String)graph.getPossibleRelatedValue(this.resource, UI.hasNameLabelMode, (Binding)Bindings.STRING);
                    return NameLabelMode.fromString(value);
                }
            }));
        }
        catch (DatabaseException databaseException) {
            return NameLabelMode.getDefault();
        }
    }

    public static void setNameLabelMode(RequestProcessor processor, final NameLabelMode mode) {
        try {
            VirtualGraphSupport support = (VirtualGraphSupport)processor.getService(VirtualGraphSupport.class);
            VirtualGraph vg = support.getWorkspacePersistent("preferences");
            processor.syncRequest((Write)new WriteRequest(vg){

                public void perform(WriteGraph graph) throws DatabaseException {
                    PlatformUIResource UI = PlatformUIResource.getInstance((ReadGraph)graph);
                    Resource project = Simantics.getProjectResource();
                    graph.deny(project, UI.hasNameLabelMode);
                    graph.claim(project, UI.hasNameLabelMode, mode.asResource(UI));
                }
            });
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    public static String modalName(ReadGraph graph, Resource resource) throws DatabaseException {
        NameLabelMode mode = NameLabelUtil.getNameLabelMode((RequestProcessor)graph);
        return NameLabelUtil.modalName(graph, resource, mode);
    }

    public static String modalName(ReadGraph graph, Variable variable) throws DatabaseException {
        NameLabelMode mode = NameLabelUtil.getNameLabelMode((RequestProcessor)graph);
        return NameLabelUtil.modalName(graph, variable, mode);
    }

    public static String modalName(ReadGraph graph, Resource resource, NameLabelMode mode) throws DatabaseException {
        switch (mode) {
            case NAME: {
                return Versions.getStandardNameString((ReadGraph)graph, (Resource)resource);
            }
            case LABEL: {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                String label = (String)graph.getPossibleRelatedValue2(resource, L0.HasLabel, (Binding)Bindings.STRING);
                if (label == null || label.isEmpty()) {
                    label = "no label (" + Versions.getStandardNameString((ReadGraph)graph, (Resource)resource) + ")";
                }
                return label;
            }
            case NAME_AND_LABEL: {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                String name = Versions.getStandardNameString((ReadGraph)graph, (Resource)resource);
                String l = (String)graph.getPossibleRelatedValue2(resource, L0.HasLabel, (Binding)Bindings.STRING);
                String label = String.valueOf(name) + (l != null && !l.isEmpty() ? " (" + l + ")" : "");
                return label;
            }
            case LABEL_AND_NAME: {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                String name = Versions.getStandardNameString((ReadGraph)graph, (Resource)resource);
                String l = (String)graph.getPossibleRelatedValue2(resource, L0.HasLabel, (Binding)Bindings.STRING);
                String label = String.valueOf(l != null && !l.isEmpty() ? l : "no label") + " (" + name + ")";
                return label;
            }
        }
        throw new UnsupportedOperationException("unsupported mode: " + (Object)((Object)mode));
    }

    public static String modalName(ReadGraph graph, Variable variable, NameLabelMode mode) throws DatabaseException {
        switch (mode) {
            case NAME: {
                return NameLabelUtil.name(graph, variable);
            }
            case LABEL: {
                String label = NameLabelUtil.label(graph, variable);
                if (label == null || label.isEmpty()) {
                    label = "no label (" + NameLabelUtil.name(graph, variable) + ")";
                }
                return label;
            }
            case NAME_AND_LABEL: {
                String name = NameLabelUtil.name(graph, variable);
                String l = NameLabelUtil.label(graph, variable);
                String label = String.valueOf(name) + (l != null && !l.isEmpty() ? " (" + l + ")" : "");
                return label;
            }
            case LABEL_AND_NAME: {
                String name = NameLabelUtil.name(graph, variable);
                String l = NameLabelUtil.label(graph, variable);
                String label = String.valueOf(l != null && !l.isEmpty() ? l : "no label") + " (" + name + ")";
                return label;
            }
        }
        throw new UnsupportedOperationException("unsupported mode: " + (Object)((Object)mode));
    }

    public static String modalName(String name, String label, NameLabelMode mode) {
        switch (mode) {
            case NAME: {
                return name;
            }
            case LABEL: {
                return label == null || label.isEmpty() ? (label = "no label (" + name + ")") : label;
            }
            case NAME_AND_LABEL: {
                return String.valueOf(name) + (label != null && !label.isEmpty() ? " (" + label + ")" : "");
            }
            case LABEL_AND_NAME: {
                return String.valueOf(label != null && !label.isEmpty() ? label : "no label") + " (" + name + ")";
            }
        }
        throw new UnsupportedOperationException("unsupported mode: " + (Object)((Object)mode));
    }

    private static String name(ReadGraph graph, Variable v) throws DatabaseException {
        Resource r = v.getPossibleRepresents(graph);
        return r != null ? Versions.getStandardNameString((ReadGraph)graph, (Resource)r) : v.getName(graph);
    }

    private static String label(ReadGraph graph, Variable v) throws DatabaseException {
        return (String)v.getPossiblePropertyValue(graph, "HasLabel", (Binding)Bindings.STRING);
    }
}

