/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.internal.contributions.search;

import java.net.URL;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.simantics.Simantics;
import org.simantics.db.Session;
import org.simantics.db.layer0.request.ActiveModels;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextChangedListener;
import org.simantics.db.management.SessionContextChangedEvent;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.workbench.internal.contributions.search.ActiveModelsListener;
import org.simantics.workbench.search.ISearchService;
import org.simantics.workbench.search.SearchQuery;

public class BrowserView
extends ViewPart {
    public static final String ID = "org.simantics.workbench.search.browser";
    public static final String LAST_QUERY_PROPERTY = "org.simantics.workbench.search.browser.lastQuery";
    private Browser browser;
    private boolean disposed;
    private ActiveModelsListener currentListener;
    private ISessionContextChangedListener sessionListener = new ISessionContextChangedListener(){

        public void sessionContextChanged(SessionContextChangedEvent event) {
            ISessionContext ctx = event.getNewValue();
            final Session newSession = ctx != null ? ctx.peekSession() : null;
            SWTUtils.asyncExec((Widget)BrowserView.this.browser, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!BrowserView.this.disposed) {
                        BrowserView.this.trackActiveModels(newSession);
                    }
                }
            });
        }
    };

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 0);
        this.scheduleInitializeViewContent(false);
        Simantics.getSessionContextProvider().addContextChangedListener(this.sessionListener);
        this.trackActiveModels(Simantics.peekSession());
    }

    private void trackActiveModels(Session session) {
        if (this.currentListener != null) {
            this.currentListener.dispose();
            this.currentListener = null;
        }
        if (session != null) {
            LifecycleSupport lfs = (LifecycleSupport)session.peekService(LifecycleSupport.class);
            if (lfs == null) {
                return;
            }
            if (lfs.isClosed()) {
                return;
            }
            ActiveModelsListener listener = new ActiveModelsListener(new Runnable(){

                @Override
                public void run() {
                    BrowserView.this.scheduleInitializeViewContent(true);
                }
            });
            session.registerService(ActiveModelsListener.class, (Object)listener);
            session.asyncRequest((Read)new ActiveModels(Simantics.getProjectResource()), (Listener)listener);
            this.currentListener = listener;
        }
    }

    protected void scheduleInitializeViewContent(final boolean force) {
        SWTUtils.asyncExec((Widget)this.browser, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (BrowserView.this.disposed) {
                    return;
                }
                String lastQuery = BrowserView.this.getPartProperty(BrowserView.LAST_QUERY_PROPERTY);
                if (force || lastQuery == null) {
                    BrowserView.this.initializeViewContent();
                }
            }
        });
    }

    protected void initializeViewContent() {
        SearchQuery query = new SearchQuery("");
        query.setSearchFlag("NameSearch", "on");
        query.setSearchFlag("TypesSearch", "on");
        ISearchService searchService = (ISearchService)PlatformUI.getWorkbench().getService(ISearchService.class);
        if (searchService != null) {
            searchService.performQuery(query, ISearchService.ResultBrowser.VIEW, false);
        }
    }

    public void dispose() {
        this.disposed = true;
        super.dispose();
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setUrl(URL url) {
        this.getBrowser().setUrl(url.toString());
    }

    public void setContentDescription(String description) {
        super.setContentDescription(description);
    }
}

