/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.internal.contributions;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.simantics.Simantics;
import org.simantics.db.Session;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextChangedListener;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.SessionContextChangedEvent;
import org.simantics.ui.jobs.SessionGarbageCollectorJob;
import org.simantics.workbench.internal.Activator;

public class FlushRequestsButtonTrim
extends Composite {
    LocalResourceManager resourceManager;
    SessionContextListener listener = new SessionContextListener();
    private Button b;

    public FlushRequestsButtonTrim(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.b = new Button((Composite)this, 8);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.b);
        final ISessionContextProvider provider = Simantics.getSessionContextProvider();
        if (provider != null) {
            provider.addContextChangedListener((ISessionContextChangedListener)this.listener);
        }
        this.b.setToolTipText("Flush database caches");
        this.b.setImage(this.resourceManager.createImage(Activator.getImageDescriptor("img/paintcan.png")));
        this.b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Session session = Simantics.peekSession();
                if (session != null) {
                    SessionGarbageCollectorJob.getInstance().rescheduleNow();
                }
            }
        });
        this.b.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                provider.removeContextChangedListener((ISessionContextChangedListener)FlushRequestsButtonTrim.this.listener);
            }
        });
        this.sessionChanged(Simantics.getSessionContext());
    }

    private void sessionChanged(ISessionContext sessionContext) {
        this.b.setEnabled(sessionContext != null);
    }

    class SessionContextListener
    implements ISessionContextChangedListener {
        SessionContextListener() {
        }

        public void sessionContextChanged(final SessionContextChangedEvent event) {
            if (FlushRequestsButtonTrim.this.isDisposed()) {
                return;
            }
            FlushRequestsButtonTrim.this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (FlushRequestsButtonTrim.this.isDisposed()) {
                        return;
                    }
                    FlushRequestsButtonTrim.this.sessionChanged(event.getNewValue());
                }
            });
        }
    }
}

