/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.workbench.internal.preferences;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.AutosavePreferences;
import org.simantics.AutosaveVirtualGraphs;

/**
 * @author Tuukka Lehtonen <tuukka.lehtonen@semantum.fi>
 */
public class AutosavePreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {

    public AutosavePreferencePage() {
        super(GRID);

        IPreferenceStore pf = new ScopedPreferenceStore(InstanceScope.INSTANCE, AutosavePreferences.P_NODE);
        setPreferenceStore( pf );
    }

    @Override
    protected void createFieldEditors() {
        BooleanFieldEditor autosaveEnabled = new BooleanFieldEditor(
                AutosavePreferences.P_VG_AUTOSAVE_ENABLED,
                "Virtual Graph autosave enabled",
                getFieldEditorParent());
        addField(autosaveEnabled);

        IntegerFieldEditor autosaveInterval = new IntegerFieldEditor(
                AutosavePreferences.P_VG_AUTOSAVE_INTERVAL, 
                "Virtual Graph autosave interval (seconds)", 
                getFieldEditorParent());
        autosaveInterval.setValidRange(1, Integer.MAX_VALUE);
        autosaveInterval.setErrorMessage("Autosave interval must be positive");
        addField(autosaveInterval);
    }

    @Override
    public boolean performOk() {
        if(super.performOk()) {
            AutosaveVirtualGraphs.saveVirtualGraphsPeriodically();
            return true;
        }
        else
            return false;
    }

    @Override
    public void init(IWorkbench workbench) {
    }

}
