package org.simantics.workbench.internal.contributions.search;


import org.eclipse.core.expressions.Expression;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.expressions.ActivePartExpression;
import org.eclipse.ui.internal.expressions.WorkbenchWindowExpression;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.services.AbstractServiceFactory;
import org.eclipse.ui.services.IServiceLocator;
import org.simantics.workbench.search.ISearchService;

public class SearchServiceFactory extends AbstractServiceFactory {


	@SuppressWarnings("rawtypes")
	@Override
	public Object create(Class serviceInterface, IServiceLocator parentLocator,
			IServiceLocator locator) {
		if (!ISearchService.class.equals(serviceInterface))
			return null;
		IWorkbenchLocationService wls = (IWorkbenchLocationService) locator
				.getService(IWorkbenchLocationService.class);
		final IWorkbench wb = wls.getWorkbench();
		if (wb == null) {
			return null;
		}
		
		Object parent = parentLocator.getService(serviceInterface);
		if (parent == null) {
			return new SearchServiceImpl();
		}
		final IWorkbenchWindow window = wls.getWorkbenchWindow();
		final IWorkbenchPartSite site = wls.getPartSite();
		if (site == null) {
			Expression exp = new WorkbenchWindowExpression(window);
			return new SlaveSearchService((ISearchService)parent, exp);
		}
		if (parent instanceof SlaveSearchService) {
			Expression parentExp = ((SlaveSearchService) parent).getDefaultExpression();
			return new NestableSearchService((ISearchService)parent, parentExp);
		}
		
		Expression exp = new ActivePartExpression(site.getPart());
		return new SlaveSearchService((ISearchService)parent, exp);
	}

}
