package org.simantics.workbench.internal.contributions.e4;

import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.simantics.ui.workbench.e4.E4WorkbenchUtils;

public class ActivatePartHandler {

    @CanExecute
    public boolean canExecute(MApplication app, EModelService modelService) {
        MPartStack partStack = E4WorkbenchUtils.getEditorPartStack(modelService, app);
        if (partStack.getChildren().size() > 0)
            return true;
        return false;
    }

    @Execute
    public void activatePart(MApplication app, EModelService modelService, EPartService partService) {
        MPartStack partStack = E4WorkbenchUtils.getEditorPartStack(modelService, app);
        MStackElement elem = partStack.getSelectedElement();
        MPart part = (MPart) elem;
        partService.activate(part);
    }

}
