/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.workbench.internal.contributions;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.simantics.Simantics;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextChangedListener;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.SessionContextChangedEvent;
import org.simantics.ui.SimanticsUI;
import org.simantics.workbench.internal.Activator;


/**
 * @author Tuukka Lehtonen
 */
public class GraphRequestStatusContribution extends WorkbenchWindowControlContribution implements ISessionContextChangedListener {

    GraphRequestStatusTrim  trim;
    ISessionContextProvider contextProvider;

    @Override
    public String getId() {
        return "org.simantics.workbench.db.monitor";
    }

    @Override
    protected Control createControl(Composite parent) {
        IWorkbenchWindow window = getWorkbenchWindow();
        contextProvider = SimanticsUI.getSessionContextProvider(window);
        contextProvider.addContextChangedListener(this);

        trim = new GraphRequestStatusTrim(parent, Activator.getDefault().getPreferenceStore());
        ISessionContext ctx = Simantics.getSessionContext();
        if (ctx != null) {
            trim.attachToSession(ctx.getSession());
        }
        return trim;
    }

    @Override
    public void dispose() {
        contextProvider.removeContextChangedListener(this);
        trim = null;
        super.dispose();
    }

    @Override
    public void sessionContextChanged(SessionContextChangedEvent event) {
//        System.out.println("session changed for '" + event.getHandle() + "' from '" + event.getOldValue() + "' to '" + event.getNewValue() + "'");
        GraphRequestStatusTrim trim = this.trim;
        if (trim != null) {
            ISessionContext ctx = event.getNewValue();
            trim.attachToSession((ctx != null) ? ctx.getSession() : null);
        }
    }

}
