package org.simantics.workbench.internal;

import java.util.concurrent.atomic.AtomicBoolean;

import org.eclipse.jface.dialogs.MessageDialog;
import org.simantics.Simantics;
import org.simantics.db.Session;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.dialogs.SafeMessageDialog;

/**
 * @author Tuukka Lehtonen
 */
final class ApplicationUtil {

    /**
     * Used to make sure that the user has a choice to save the changes into the
     * active database before closing.
     */
    public static boolean allowShutdown(AtomicBoolean saveAtExit) {
        try {
            if (hasUnsavedChanges()) {
                String[] buttons = { "&Save", "&Don't save", "&Cancel" };
                int result = SafeMessageDialog.doMessageDialog("Save Resources", null, "Save changes before closing ?",
                        MessageDialog.QUESTION, buttons, 2);

                switch (result) {
                    case 0:
                        saveAtExit.set(true);
                        break;
                    case 1:
                        saveAtExit.set(false);
                        break;
                    case 2:
                        return false;
                    default:
                        return false;
                }
            }

            // If any errors occur during this check, just log them, but allow
            // for the program to be closed and make sure nothing is saved,
            // since it would probably be corrupt.
        } catch (RuntimeException e) {
            ErrorLogger.defaultLogError(
                    "RuntimeException occured while querying database session for unsaved changes.", e);
            saveAtExit.set(false);
        } catch (Error e) {
            ErrorLogger.defaultLogError("Error occured while querying database session for unsaved changes.", e);
            saveAtExit.set(false);
        }
        return true;
    }

    public static boolean hasUnsavedChanges() {
        Session session = Simantics.peekSession();
        if (session == null)
            return false;

        // hasChangesToSave is deprecated
//        LifecycleSupport lfs = session.getService(LifecycleSupport.class);
//        try {
//            return lfs.hasChangesToSave();
//        } catch (DatabaseException e) {
//            ErrorLogger.defaultLogError(
//                    "Problems encountered while checking for unsaved changes, see exception for details.", e);
//        }
        return false;
    }

}
