/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.wiki.ui.editor;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.simantics.wiki.ui.editor.IExportable;

public class WikiExportPDFAction
extends Action {
    final IExportable exportable;

    public WikiExportPDFAction(IExportable exportable) {
        this.exportable = exportable;
    }

    public void run() {
        Shell shell = Display.getCurrent().getActiveShell();
        FileDialog fd = new FileDialog(shell, 8192);
        fd.setText("Save PDF");
        fd.setFilterPath("C:/");
        String[] filterExt = new String[]{"*.pdf", "*.*"};
        fd.setFilterExtensions(filterExt);
        String filename = fd.open();
        if (filename == null) {
            return;
        }
        this.exportPDF(filename);
    }

    protected void exportPDF(String filename) {
        try (Document document = new Document(PageSize.A4, 36.0f, 36.0f, 36.0f, 36.0f);){
            try {
                PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(filename));
                document.open();
                this.exportable.export(document, writer);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                document.close();
            }
            catch (DocumentException e) {
                e.printStackTrace();
                document.close();
            }
        }
    }
}

