/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - (#7066) initial API and implementation
 *******************************************************************************/
package org.simantics.views.text.internal;

import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.widgets.Control;

/**
 * @author Tuukka Lehtonen
 * @since 1.28.0
 */
public class TextViewerConstants {

	/**
	 * The UI focus control context used for enabling normal text undo/redo for
	 * {@link TextViewer} controls.
	 */
	public static final String CONTEXT_IN_TEXT_VIEWER = "inTextViewer";

	/**
	 * A key used for storing an {@link IUndoManager} as data of a
	 * {@link Control} using {@link Control#setData(String, Object)}.
	 */
	public static final String KEY_UNDO_MANAGER = "undoManager";

}
