package org.simantics.views.swt;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/**
 * 
 * @author Antti Villberg
 */
public class WizardFactory implements IExecutableExtensionFactory, IExecutableExtension {
    
    private IConfigurationElement config;

    private String id;

    private String propertyName;

    public WizardFactory() {
        // do nothing
    }

    private Object configure(Object obj) throws CoreException {
        if (obj instanceof IExecutableExtension) {
            ((IExecutableExtension) obj).setInitializationData(config, propertyName, null);
        }
        return obj;
    }

    @Override
    public Object create() throws CoreException {
    	
    	return configure(new ModelledWizard(id));
        
    }

    @Override
    public void setInitializationData(IConfigurationElement config, String propertyName, Object data)
    throws CoreException {
        //System.out.println("setInitializationData: " + config + ", " + propertyName + ", " + data);

        if (data instanceof String) {
            id = (String) data;
        } else {
            throw new CoreException(new Status(IStatus.ERROR,
                    Activator.PLUGIN_ID, 0,
                    "Data argument must be a String for " + getClass(), null)); //$NON-NLS-1$
        }
        this.config = config;
        this.propertyName = propertyName;
    }

}
