package org.simantics.views.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWizard;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.ModelledAction;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.PossibleAdapter;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.ontology.ScenegraphResources;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.views.ontology.ViewsResources;

/**
 * @author Tuukka Lehtonen
 */
public class ModelledWizard extends Wizard implements IWorkbenchWizard, ModelledAction {

	final String configurationURI;
	
	final private ArrayList<IWizardPage> pages = new ArrayList<IWizardPage>();
	final private ArrayList<ModelledWizardPage> modelledPages = new ArrayList<ModelledWizardPage>();
	
	
	private Function1<Object, Object> finishAction;
	private Resource runtime;
	
    public ModelledWizard(String configurationURI) {
        setNeedsProgressMonitor(true);
        this.configurationURI = configurationURI;
    }
    
    public List<ModelledWizardPage> getModelledPages() {
    	return modelledPages;
    }

    @Override
    public void addPages() {
        super.addPages();
        for(IWizardPage page : pages) addPage(page);
    }

    @Override
    public boolean performFinish() {
    	
    	finishAction.apply(this);
        return true;
        
    }

    public void loadPages(IWorkbenchSite site, ISessionContext context, final WidgetSupport support) throws DatabaseException {

		runtime = Simantics.getSession().sync(new WriteResultRequest<Resource>(Simantics.getSession().getService(VirtualGraph.class)) {
            @Override
            public Resource perform(WriteGraph graph) throws DatabaseException {
		    	Layer0 L0 = Layer0.getInstance(graph);
		    	ScenegraphResources SG = ScenegraphResources.getInstance(graph);
		    	Resource runtime = graph.newResource();
				graph.claim(runtime, L0.InstanceOf, null, SG.Runtime);
				return runtime;
            }
        });
		
		finishAction = Simantics.getSession().syncRequest(new Read<Function1<Object, Object>>() {
			@Override
			public Function1<Object, Object> perform(ReadGraph graph) throws DatabaseException {
				ViewsResources VIEW = ViewsResources.getInstance(graph);
				Resource configuration = graph.getResource(configurationURI);
				return graph.getPossibleRelatedValue2(configuration, VIEW.Wizard_FinishAction);
			}
		});
    	
		List<Resource> pageResources = Simantics.getSession().syncRequest(new Read<List<Resource>>() {

			@Override
			public List<Resource> perform(ReadGraph graph) throws DatabaseException {
				ViewsResources VIEW = ViewsResources.getInstance(graph);
				Resource configuration = graph.getResource(configurationURI);
				Resource pageList = graph.getPossibleObject(configuration, VIEW.Wizard_Pages);
				if(pageList == null) return Collections.emptyList();
				return ListUtils.toList(graph, pageList);
			}
			
		});

		for(final Resource page : pageResources) {

			ModelledWizardPage p = Simantics.getSession().syncRequest(new PossibleAdapter<ModelledWizardPage>(page, ModelledWizardPage.class));			
			pages.add(p.create(context, support, runtime));
			modelledPages.add(p);
			
		}
    	
    }
    
	@Override
	public Runnable create(IWorkbenchSite site, ISessionContext context, final WidgetSupport support) throws DatabaseException {

		List<Resource> pageResources = Simantics.getSession().syncRequest(new Read<List<Resource>>() {

			@Override
			public List<Resource> perform(ReadGraph graph) throws DatabaseException {
				ViewsResources VIEW = ViewsResources.getInstance(graph);
				Resource configuration = graph.getResource(configurationURI);
				Resource pageList = graph.getPossibleObject(configuration, VIEW.Wizard_Pages);
				if(pageList == null) return Collections.emptyList();
				return ListUtils.toList(graph, pageList);
			}
			
		});

		runtime = Simantics.getSession().sync(new WriteResultRequest<Resource>(Simantics.getSession().getService(VirtualGraph.class)) {
            @Override
            public Resource perform(WriteGraph graph) throws DatabaseException {
		    	Layer0 L0 = Layer0.getInstance(graph);
		    	ScenegraphResources SG = ScenegraphResources.getInstance(graph);
		    	Resource runtime = graph.newResource();
				graph.claim(runtime, L0.InstanceOf, null, SG.Runtime);
				return runtime;
            }
        });
		
		for(final Resource page : pageResources) {

			ModelledWizardPage p = Simantics.getSession().syncRequest(new PossibleAdapter<ModelledWizardPage>(page, ModelledWizardPage.class));			
			pages.add(p.create(context, support, runtime));
			
		}
		
		finishAction = Simantics.getSession().syncRequest(new Read<Function1<Object, Object>>() {
			@Override
			public Function1<Object, Object> perform(ReadGraph graph) throws DatabaseException {
				ViewsResources VIEW = ViewsResources.getInstance(graph);
				Resource configuration = graph.getResource(configurationURI);
				return graph.getPossibleRelatedValue2(configuration, VIEW.Wizard_FinishAction);
			}
		});
		
		return null;
		
	}

	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		
		WidgetSupportImpl support = new WidgetSupportImpl();
		try {
			loadPages(null, Simantics.getSessionContext(), support);
			support.finish();
			support.fireInput(Simantics.getSessionContext(), selection);
		} catch (DatabaseException e) {
			Logger.defaultLogError(e);
		}
		
	}

}
