/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.bytes;

import org.simantics.utils.bytes.BEInt;
import org.simantics.utils.strings.EString;

public class BEString {
    public static byte[] toBytes(String s) {
        int size = s.length();
        byte[] array = new byte[size + 4];
        BEInt.write(size, array);
        int i = 0;
        while (i < size) {
            array[i + 4] = (byte)s.charAt(i);
            ++i;
        }
        return array;
    }

    public static void write(String str, byte[] array, int offset) {
        int size = str.length();
        if (offset + 4 + size > array.length) {
            throw new IndexOutOfBoundsException();
        }
        BEInt.write(size, array, offset);
        int i = 0;
        while (i < size) {
            array[i + 4 + offset] = (byte)str.charAt(i);
            ++i;
        }
    }

    public static void write(String str, byte[] array) {
        int size = str.length();
        if (4 + size > array.length) {
            throw new IndexOutOfBoundsException();
        }
        BEInt.write(size, array);
        int i = 0;
        while (i < size) {
            array[i + 4] = (byte)str.charAt(i);
            ++i;
        }
    }

    public static String toString(byte[] array, int offset) {
        if (offset + 4 > array.length) {
            throw new IndexOutOfBoundsException();
        }
        int size = BEInt.toInt(array, offset);
        if (offset + 4 + size > array.length) {
            throw new IndexOutOfBoundsException();
        }
        char[] chars = new char[size];
        int i = 0;
        while (i < size) {
            chars[i] = (char)(array[i + 4 + offset] & 0xFF);
            ++i;
        }
        return new String(chars);
    }

    public static String toString(byte[] array) {
        if (4 > array.length) {
            throw new IndexOutOfBoundsException();
        }
        int size = BEInt.toInt(array);
        if (4 + size > array.length) {
            throw new IndexOutOfBoundsException();
        }
        char[] chars = new char[size];
        int i = 0;
        while (i < size) {
            chars[i] = (char)(array[i + 4] & 0xFF);
            ++i;
        }
        return new String(chars);
    }

    public static String intToHex(int value, int decimals) {
        String result = "";
        int i = 0;
        while (i < decimals) {
            result = String.valueOf(result) + EString.HEX_VALUES[value >> 4 & 0xF];
            result = String.valueOf(result) + EString.HEX_VALUES[value & 0xF];
            value >>= 8;
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
        String value = "STRING 01234\u0080\u0081\u00ff";
        int X = 500;
        System.out.println(String.valueOf(X) + " = " + BEString.intToHex(X, 4));
        byte[] array = BEString.toBytes(value);
        System.out.print(value);
        System.out.print(" = ");
        BEString.printByteArray(array);
        System.out.println();
        BEString.write(value, array);
        System.out.print(value);
        System.out.print(" = ");
        BEString.printByteArray(array);
        System.out.println();
        BEString.write(value, array, 0);
        System.out.print(value);
        System.out.print(" = ");
        BEString.printByteArray(array);
        System.out.println();
        value = BEString.toString(array, 0);
        BEString.printByteArray(array);
        System.out.print(" = ");
        System.out.print(value);
        System.out.println();
        value = BEString.toString(array);
        BEString.printByteArray(array);
        System.out.print(" = ");
        System.out.print(value);
        System.out.println();
        array = BEString.toBytes(value);
        System.out.print(value);
        System.out.print(" = ");
        BEString.printByteArray(array);
        System.out.println();
    }

    public static void printByteArray(byte[] array) {
        int i = 0;
        while (i < array.length) {
            System.out.print(array[i] & 0xFF);
            if (i < array.length - 1) {
                System.out.print(",");
            }
            ++i;
        }
    }
}

