/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.widgets;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.simantics.utils.ui.widgets.ITrackedColorProvider;
import org.simantics.utils.ui.widgets.TrackedModifyEvent;
import org.simantics.utils.ui.widgets.TrackedModifyListener;

public class TrackedText {
    public static final String TRACKED_TEXT_KEY = "TrackedTextKey";
    private static final int EDITING = 1;
    private static final int MODIFIED_DURING_EDITING = 2;
    private static final int MOUSE_DOWN_FIRST_TIME = 4;
    private static final int MOUSE_INSIDE_CONTROL = 8;
    private int state;
    private int caretPositionBeforeEdit;
    private String textBeforeEdit;
    private final Text text;
    private CompositeListener listener;
    private ListenerList modifyListeners;
    private IInputValidator validator;
    private ITrackedColorProvider colorProvider;
    private ResourceManager resourceManager;

    public TrackedText(Text text) {
        Assert.isNotNull((Object)text);
        this.state = 0;
        this.text = text;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)text);
        this.colorProvider = new DefaultColorProvider();
        this.initialize();
    }

    public TrackedText(Composite parent, int style) {
        this.state = 0;
        this.text = new Text(parent, style);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.text);
        this.colorProvider = new DefaultColorProvider();
        this.initialize();
    }

    public TrackedText(Text text, ITrackedColorProvider colorProvider) {
        Assert.isNotNull((Object)text, (String)"text must not be null");
        Assert.isNotNull((Object)colorProvider, (String)"colorProvider must not be null");
        this.state = 0;
        this.text = text;
        this.colorProvider = colorProvider;
        this.initialize();
    }

    public TrackedText(Composite parent, int style, ITrackedColorProvider colorProvider) {
        Assert.isNotNull((Object)colorProvider, (String)"colorProvider must not be null");
        this.state = 0;
        this.text = new Text(parent, style);
        this.colorProvider = colorProvider;
        this.initialize();
    }

    private void initialize() {
        Assert.isNotNull((Object)this.text);
        this.text.setBackground(this.colorProvider.getInactiveBackground());
        this.text.setDoubleClickEnabled(false);
        this.text.setData(TRACKED_TEXT_KEY, (Object)this);
        this.listener = new CompositeListener();
        this.text.addModifyListener((ModifyListener)this.listener);
        this.text.addDisposeListener((DisposeListener)this.listener);
        this.text.addKeyListener((KeyListener)this.listener);
        this.text.addMouseTrackListener((MouseTrackListener)this.listener);
        this.text.addMouseListener((MouseListener)this.listener);
        this.text.addFocusListener((FocusListener)this.listener);
    }

    private void startEdit(boolean selectAll) {
        if (this.isEditing()) {
            System.out.println("TrackedText: BUG: startEdit called when in editing state");
        }
        this.caretPositionBeforeEdit = this.text.getCaretPosition();
        this.textBeforeEdit = this.text.getText();
        this.setBackground(this.colorProvider.getEditingBackground());
        if (selectAll) {
            this.text.selectAll();
        }
        this.state |= 5;
    }

    private void applyEdit() {
        try {
            if (this.isTextValid() != null) {
                this.text.setText(this.textBeforeEdit);
            } else if (this.isModified() && !this.text.getText().equals(this.textBeforeEdit) && this.modifyListeners != null) {
                TrackedModifyEvent event = new TrackedModifyEvent((Widget)this.text, this.text.getText());
                Object[] objectArray = this.modifyListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    ((TrackedModifyListener)o).modifyText(event);
                    ++n2;
                }
            }
        }
        finally {
            this.endEdit();
        }
    }

    private void endEdit() {
        this.isEditing();
        this.setBackground(this.isMouseInsideControl() ? this.colorProvider.getHoverBackground() : this.colorProvider.getInactiveBackground());
        this.text.setSelection(this.text.getCharCount());
        this.state &= 0xFFFFFFFA;
        this.setModified(false);
    }

    private void revertEdit() {
        if (!this.isEditing()) {
            System.out.println("BUG: revertEdit called when not in editing state");
        }
        this.text.setText(this.textBeforeEdit);
        this.text.setSelection(this.caretPositionBeforeEdit);
        this.setBackground(this.isMouseInsideControl() ? this.colorProvider.getHoverBackground() : this.colorProvider.getInactiveBackground());
        this.state &= 0xFFFFFFFA;
        this.setModified(false);
    }

    public boolean isEditing() {
        return (this.state & 1) != 0;
    }

    private void setModified(boolean modified) {
        this.state = modified ? (this.state |= 2) : (this.state &= 0xFFFFFFFD);
    }

    private boolean isMouseInsideControl() {
        return (this.state & 8) != 0;
    }

    private void setMouseInsideControl(boolean inside) {
        this.state = inside ? (this.state |= 8) : (this.state &= 0xFFFFFFF7);
    }

    public boolean isModified() {
        return (this.state & 2) != 0;
    }

    public void setEditable(boolean editable) {
        if (editable) {
            this.text.setEditable(true);
            this.setBackground(this.isMouseInsideControl() ? this.colorProvider.getHoverBackground() : this.colorProvider.getInactiveBackground());
        } else {
            this.text.setEditable(false);
            this.text.setBackground(null);
        }
    }

    public void setText(String text) {
        this.text.setText(text);
    }

    public void setTextWithoutNotify(String text) {
        this.text.removeModifyListener((ModifyListener)this.listener);
        this.setText(text);
        this.text.addModifyListener((ModifyListener)this.listener);
    }

    public Text getWidget() {
        return this.text;
    }

    public synchronized void addModifyListener(TrackedModifyListener listener) {
        if (this.modifyListeners == null) {
            this.modifyListeners = new ListenerList(1);
        }
        this.modifyListeners.add((Object)listener);
    }

    public synchronized void removeModifyListener(TrackedModifyListener listener) {
        if (this.modifyListeners == null) {
            return;
        }
        this.modifyListeners.remove((Object)listener);
    }

    public void setInputValidator(IInputValidator validator) {
        if (validator != this.validator) {
            this.validator = validator;
        }
    }

    private String isTextValid() {
        if (this.validator != null) {
            return this.validator.isValid(this.getWidget().getText());
        }
        return null;
    }

    public void setColorProvider(ITrackedColorProvider provider) {
        Assert.isNotNull((Object)provider);
        this.colorProvider = provider;
    }

    public void updateColor() {
        if (!this.isEditing()) {
            if (!this.text.getEditable()) {
                this.text.setBackground(null);
            } else {
                this.setBackground(this.isMouseInsideControl() ? this.colorProvider.getHoverBackground() : this.colorProvider.getInactiveBackground());
            }
        }
    }

    private void setBackground(Color background) {
        if (!this.text.getEditable() || background != null && background.isDisposed()) {
            return;
        }
        this.text.setBackground(background);
    }

    private class CompositeListener
    implements ModifyListener,
    DisposeListener,
    KeyListener,
    MouseTrackListener,
    MouseListener,
    FocusListener {
        private CompositeListener() {
        }

        public void modifyText(ModifyEvent e) {
            TrackedText.this.setModified(true);
            String valid = TrackedText.this.isTextValid();
            if (valid != null) {
                TrackedText.this.setBackground(TrackedText.this.colorProvider.getInvalidBackground());
            } else if (TrackedText.this.isEditing()) {
                TrackedText.this.setBackground(TrackedText.this.colorProvider.getEditingBackground());
            } else {
                TrackedText.this.setBackground(TrackedText.this.colorProvider.getInactiveBackground());
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            TrackedText.this.getWidget().removeModifyListener((ModifyListener)this);
        }

        private boolean isMultiLine() {
            return (TrackedText.this.text.getStyle() & 2) != 0;
        }

        private boolean hasMultiLineCommitModifier(KeyEvent e) {
            return (e.stateMask & 0x40000) != 0;
        }

        public void keyPressed(KeyEvent e) {
            if (!TrackedText.this.isEditing()) {
                if (e.keyCode == 27) {
                    return;
                }
                if (!this.isMultiLine()) {
                    if (e.keyCode == 0x100000B || e.keyCode == 13 || e.keyCode == 0x1000050) {
                        TrackedText.this.startEdit(true);
                    } else if (e.character != '\u0000') {
                        TrackedText.this.startEdit(false);
                    }
                } else if (e.keyCode == 0x100000B) {
                    TrackedText.this.startEdit(true);
                } else if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    if (this.hasMultiLineCommitModifier(e)) {
                        e.doit = false;
                    } else {
                        TrackedText.this.startEdit(false);
                    }
                } else if (e.keyCode == 9) {
                    TrackedText.this.text.traverse((e.stateMask & 0x20000) != 0 ? 8 : 16);
                    e.doit = false;
                } else if (e.character != '\u0000') {
                    TrackedText.this.startEdit(false);
                }
            } else {
                if (e.keyCode == 27) {
                    TrackedText.this.revertEdit();
                }
                if (!this.isMultiLine()) {
                    if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                        TrackedText.this.applyEdit();
                    }
                } else if ((e.keyCode == 13 || e.keyCode == 0x1000050) && this.hasMultiLineCommitModifier(e)) {
                    TrackedText.this.applyEdit();
                    e.doit = false;
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void mouseEnter(MouseEvent e) {
            if (!TrackedText.this.isEditing()) {
                TrackedText.this.setBackground(TrackedText.this.colorProvider.getHoverBackground());
            }
            TrackedText.this.setMouseInsideControl(true);
        }

        public void mouseExit(MouseEvent e) {
            if (!TrackedText.this.isEditing()) {
                TrackedText.this.setBackground(TrackedText.this.colorProvider.getInactiveBackground());
            }
            TrackedText.this.setMouseInsideControl(false);
        }

        public void mouseHover(MouseEvent e) {
            TrackedText.this.setMouseInsideControl(true);
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (e.button == 1) {
                TrackedText.this.getWidget().selectAll();
            }
        }

        public void mouseDown(MouseEvent e) {
            if (!TrackedText.this.isEditing()) {
                if (e.button == 1) {
                    TrackedText.this.startEdit(true);
                }
            } else if (e.button == 1 && (TrackedText.this.state & 4) != 0) {
                TrackedText.this.getWidget().selectAll();
                TrackedText trackedText = TrackedText.this;
                trackedText.state = trackedText.state & 0xFFFFFFFB;
            }
        }

        public void mouseUp(MouseEvent e) {
        }

        public void focusGained(FocusEvent e) {
            if (!TrackedText.this.isEditing() && !this.isMultiLine()) {
                TrackedText.this.startEdit(true);
            }
        }

        public void focusLost(FocusEvent e) {
            if (TrackedText.this.isEditing()) {
                TrackedText.this.applyEdit();
            }
        }
    }

    private class DefaultColorProvider
    implements ITrackedColorProvider {
        private final ColorDescriptor highlightColor = ColorDescriptor.createFrom((RGB)new RGB(254, 255, 197));
        private final ColorDescriptor inactiveColor = ColorDescriptor.createFrom((RGB)new RGB(245, 246, 190));
        private final ColorDescriptor invalidInputColor = ColorDescriptor.createFrom((RGB)new RGB(255, 128, 128));

        private DefaultColorProvider() {
        }

        @Override
        public Color getEditingBackground() {
            return null;
        }

        @Override
        public Color getHoverBackground() {
            return TrackedText.this.resourceManager.createColor(this.highlightColor);
        }

        @Override
        public Color getInactiveBackground() {
            return TrackedText.this.resourceManager.createColor(this.inactiveColor);
        }

        @Override
        public Color getInvalidBackground() {
            return TrackedText.this.resourceManager.createColor(this.invalidInputColor);
        }
    }
}

