/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.widgets;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.simantics.utils.ui.widgets.TrackedModifyEvent;
import org.simantics.utils.ui.widgets.TrackedModifyListener;

public class TrackedCCombo {
    private static final int EDITING = 1;
    private static final int MODIFIED_DURING_EDITING = 2;
    private static final int MOUSE_DOWN_FIRST_TIME = 4;
    private int state;
    private String textBeforeEdit;
    private CCombo combo;
    private CompositeListener listener;
    private ListenerList modifyListeners;
    private IInputValidator validator;
    private static Color highlightColor = new Color(null, 254, 255, 197);
    private static Color inactiveColor = new Color(null, 245, 246, 190);
    private static Color invalidInputColor = new Color(null, 255, 128, 128);

    public TrackedCCombo(CCombo combo) {
        Assert.isNotNull((Object)combo);
        this.state = 0;
        this.combo = combo;
        this.initialize();
    }

    public TrackedCCombo(Composite parent, int style) {
        this.state = 0;
        this.combo = new CCombo(parent, style);
        this.initialize();
    }

    private void initialize() {
        Assert.isNotNull((Object)this.combo);
        this.combo.setBackground(inactiveColor);
        this.listener = new CompositeListener();
        this.combo.addModifyListener((ModifyListener)this.listener);
        this.combo.addDisposeListener((DisposeListener)this.listener);
        this.combo.addKeyListener((KeyListener)this.listener);
        this.combo.addMouseTrackListener((MouseTrackListener)this.listener);
        this.combo.addMouseListener((MouseListener)this.listener);
        this.combo.addFocusListener((FocusListener)this.listener);
    }

    private void startEdit(boolean selectAll) {
        if (this.isEditing()) {
            try {
                throw new Exception("TrackedText: BUG: startEdit called when in editing state");
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        this.textBeforeEdit = this.combo.getText();
        this.combo.setBackground(null);
        this.state |= 5;
    }

    private void applyEdit() {
        try {
            if (this.isTextValid() != null) {
                this.combo.setText(this.textBeforeEdit);
            } else if (this.isModified() && !this.combo.getText().equals(this.textBeforeEdit) && this.modifyListeners != null) {
                TrackedModifyEvent event = new TrackedModifyEvent((Widget)this.combo, this.combo.getText());
                Object[] objectArray = this.modifyListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    ((TrackedModifyListener)o).modifyText(event);
                    ++n2;
                }
            }
        }
        finally {
            this.endEdit();
        }
    }

    private void endEdit() {
        if (!this.isEditing()) {
            System.out.println("BUG: endEdit called when not in editing state");
        }
        this.combo.setBackground(inactiveColor);
        this.state &= 0xFFFFFFFA;
        this.setModified(false);
    }

    private void revertEdit() {
        if (!this.isEditing()) {
            System.out.println("BUG: revertEdit called when not in editing state");
        }
        this.combo.setText(this.textBeforeEdit);
        this.combo.setBackground(inactiveColor);
        this.state &= 0xFFFFFFFA;
        this.setModified(false);
    }

    private boolean isEditing() {
        return (this.state & 1) != 0;
    }

    private void setModified(boolean modified) {
        this.state = modified ? (this.state |= 2) : (this.state &= 0xFFFFFFFD);
    }

    private boolean isModified() {
        return (this.state & 2) != 0;
    }

    public void setText(String text) {
        this.combo.setText(text);
    }

    public void setTextWithoutNotify(String text) {
        this.combo.removeModifyListener((ModifyListener)this.listener);
        this.setText(text);
        this.combo.addModifyListener((ModifyListener)this.listener);
    }

    public CCombo getWidget() {
        return this.combo;
    }

    public synchronized void addModifyListener(TrackedModifyListener listener) {
        if (this.modifyListeners == null) {
            this.modifyListeners = new ListenerList(1);
        }
        this.modifyListeners.add((Object)listener);
    }

    public synchronized void removeModifyListener(TrackedModifyListener listener) {
        if (this.modifyListeners == null) {
            return;
        }
        this.modifyListeners.remove((Object)listener);
    }

    public void setInputValidator(IInputValidator validator) {
        if (validator != this.validator) {
            this.validator = validator;
        }
    }

    private String isTextValid() {
        if (this.validator != null) {
            return this.validator.isValid(this.getWidget().getText());
        }
        return null;
    }

    private class CompositeListener
    implements ModifyListener,
    DisposeListener,
    KeyListener,
    MouseTrackListener,
    MouseListener,
    FocusListener {
        private CompositeListener() {
        }

        public void modifyText(ModifyEvent e) {
            String valid;
            if (TrackedCCombo.this.isEditing()) {
                TrackedCCombo.this.setModified(true);
            }
            if ((valid = TrackedCCombo.this.isTextValid()) != null) {
                TrackedCCombo.this.getWidget().setBackground(invalidInputColor);
            } else if (TrackedCCombo.this.isEditing()) {
                TrackedCCombo.this.getWidget().setBackground(null);
            } else {
                TrackedCCombo.this.getWidget().setBackground(inactiveColor);
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            TrackedCCombo.this.combo.removeModifyListener((ModifyListener)this);
        }

        public void keyPressed(KeyEvent e) {
            if (!TrackedCCombo.this.isEditing()) {
                if (e.keyCode == 27) {
                    return;
                }
                if (e.keyCode == 0x100000B || e.keyCode == 13 || e.keyCode == 0x1000050) {
                    TrackedCCombo.this.startEdit(true);
                } else if (e.character != '\u0000') {
                    TrackedCCombo.this.startEdit(false);
                }
            } else {
                if (e.keyCode == 27) {
                    TrackedCCombo.this.revertEdit();
                }
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    TrackedCCombo.this.applyEdit();
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void mouseEnter(MouseEvent e) {
            if (!TrackedCCombo.this.isEditing()) {
                TrackedCCombo.this.getWidget().setBackground(highlightColor);
            }
        }

        public void mouseExit(MouseEvent e) {
            if (!TrackedCCombo.this.isEditing()) {
                TrackedCCombo.this.getWidget().setBackground(inactiveColor);
            }
        }

        public void mouseHover(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            if (!TrackedCCombo.this.isEditing()) {
                if (e.button == 1) {
                    TrackedCCombo.this.startEdit(true);
                }
            } else if (e.button == 1 && (TrackedCCombo.this.state & 4) != 0) {
                TrackedCCombo trackedCCombo = TrackedCCombo.this;
                trackedCCombo.state = trackedCCombo.state & 0xFFFFFFFB;
            }
        }

        public void mouseUp(MouseEvent e) {
        }

        public void focusGained(FocusEvent e) {
            if (!TrackedCCombo.this.isEditing()) {
                TrackedCCombo.this.startEdit(true);
            }
        }

        public void focusLost(FocusEvent e) {
            if (TrackedCCombo.this.isEditing()) {
                TrackedCCombo.this.applyEdit();
            }
        }
    }
}

