/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.widgets;

import java.io.File;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.simantics.utils.ui.widgets.FileOrDirectorySelectionWidget;

public class FileSelectionWidget
extends FileOrDirectorySelectionWidget {
    String[] filterExtensions = new String[]{"*.*"};
    String[] filterNames = new String[]{"All files"};
    int style = 4096;

    public FileSelectionWidget(Composite parent, String name, int style) {
        super(parent, name, style & 0xFFFFEFBF);
        this.style = style & 0x1042;
    }

    @Override
    protected String[] openDialog() {
        String filename;
        FileDialog dialog = new FileDialog(this.getShell(), this.style);
        dialog.setFilterExtensions(this.getFilterExtensions());
        dialog.setFilterNames(this.getFilterNames());
        if (this.filename != null && this.filename.length == 1) {
            dialog.setFileName(this.filename[0]);
        }
        if ((filename = dialog.open()) == null) {
            return null;
        }
        String path = dialog.getFilterPath();
        String[] names = dialog.getFileNames();
        String[] fullpath = new String[names.length];
        int i = 0;
        while (i < names.length) {
            fullpath[i] = String.valueOf(path) + File.separator + names[i];
            ++i;
        }
        return fullpath;
    }

    @Override
    protected boolean isValid(File file) {
        boolean accept = file.exists() && file.canRead();
        return accept;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = filterExtensions;
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames = filterNames;
    }
}

