/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.jface;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ActionMenuItemAdapter
implements SelectionListener,
IPropertyChangeListener {
    private final Action action;
    private final MenuItem menuitem;

    public static MenuItem adapt(Action action, Menu parent, int style, int index) {
        int _style = ActionMenuItemAdapter._getActionStyle(action) | style;
        MenuItem mi = new MenuItem(parent, _style, index);
        new ActionMenuItemAdapter(action, mi);
        return mi;
    }

    public static MenuItem adapt(Action action, Menu parent, int style) {
        int _style = ActionMenuItemAdapter._getActionStyle(action) | style;
        MenuItem mi = new MenuItem(parent, _style);
        new ActionMenuItemAdapter(action, mi);
        return mi;
    }

    private ActionMenuItemAdapter(Action action, MenuItem menuitem) {
        this.menuitem = menuitem;
        this.action = action;
        menuitem.setText(action.getText());
        if (action.getImageDescriptor() != null) {
            menuitem.setImage(action.getImageDescriptor().createImage());
        }
        menuitem.setSelection(action.isChecked());
        menuitem.addSelectionListener((SelectionListener)this);
        action.addPropertyChangeListener((IPropertyChangeListener)this);
        menuitem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ActionMenuItemAdapter.this.action.removePropertyChangeListener((IPropertyChangeListener)ActionMenuItemAdapter.this);
                ActionMenuItemAdapter.this.menuitem.removeDisposeListener((DisposeListener)this);
            }
        });
    }

    private static int _getActionStyle(Action action) {
        int style = 8;
        if ((action.getStyle() & 2) > 0) {
            style = 32;
        }
        if ((action.getStyle() & 8) > 0) {
            style = 16;
        }
        return style;
    }

    public void widgetSelected(SelectionEvent e) {
        this.action.run();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public Action getAction() {
        return this.action;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.menuitem.setSelection(this.action.isChecked());
    }
}

