/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.internal.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;

class RecursiveContainerListener
implements ContainerListener {
    private final ContainerListener listener;

    RecursiveContainerListener(ContainerListener listener) {
        assert (listener != null);
        this.listener = listener;
    }

    private void handleAdd(Container source, Component c) {
        assert (source != null);
        assert (c != null);
        assert (this.listener != null);
        assert (EventQueue.isDispatchThread());
        this.listener.componentAdded(new ContainerEvent(source, 300, c));
        if (c instanceof Container) {
            ((Container)c).addContainerListener(this);
        }
    }

    private void handleRemove(Container source, Component c) {
        assert (source != null);
        assert (c != null);
        assert (this.listener != null);
        assert (EventQueue.isDispatchThread());
        this.listener.componentRemoved(new ContainerEvent(source, 301, c));
        if (c instanceof Container) {
            ((Container)c).removeContainerListener(this);
        }
    }

    private void handleAllAdds(Container source, Component child) {
        assert (source != null);
        assert (child != null);
        assert (EventQueue.isDispatchThread());
        if (child instanceof Container) {
            Container container = (Container)child;
            Component[] children = container.getComponents();
            int i = 0;
            while (i < children.length) {
                this.handleAllAdds(container, children[i]);
                ++i;
            }
        }
        this.handleAdd(source, child);
    }

    private void handleAllRemoves(Container source, Component child) {
        assert (source != null);
        assert (child != null);
        assert (EventQueue.isDispatchThread());
        if (child instanceof Container) {
            Container container = (Container)child;
            Component[] children = container.getComponents();
            int i = 0;
            while (i < children.length) {
                this.handleAllRemoves(container, children[i]);
                ++i;
            }
        }
        this.handleRemove(source, child);
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        assert (e != null);
        assert (EventQueue.isDispatchThread());
        Container source = (Container)e.getSource();
        this.handleAllAdds(source, e.getChild());
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        assert (e != null);
        assert (EventQueue.isDispatchThread());
        Container source = (Container)e.getSource();
        this.handleAllRemoves(source, e.getChild());
    }
}

