/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.gfx;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.simantics.utils.ui.gfx.ImageCache;

public class RGBAdjustmentImageDescriptor
extends ImageDescriptor {
    public static final PaletteData DEFAULT_PALETTEDATA = new PaletteData(0xFF0000, 65280, 255);
    ImageDescriptor desc;
    int r;
    int g;
    int b;

    public RGBAdjustmentImageDescriptor(ImageDescriptor image, int r, int g, int b) {
        this.desc = image;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public ImageData getImageData() {
        PaletteData palette = DEFAULT_PALETTEDATA;
        ImageData orig = ImageCache.getInstance().getImage(this.desc).getImageData();
        ImageData id = new ImageData(orig.width, orig.height, 24, palette);
        id.setAlpha(0, 0, 0);
        PaletteData origPalette = orig.palette;
        ImageData mask = null;
        if (orig.getTransparencyType() == 2 || orig.getTransparencyType() == 4) {
            mask = orig.getTransparencyMask();
        }
        int x = 0;
        while (x < orig.width) {
            int y = 0;
            while (y < orig.height) {
                RGB rgb = origPalette.getRGB(orig.getPixel(x, y));
                int nr = Math.min(255, rgb.red * this.r >> 8);
                int ng = Math.min(255, rgb.green * this.g >> 8);
                int nb = Math.min(255, rgb.blue * this.b >> 8);
                rgb = new RGB(nr, ng, nb);
                id.setPixel(x, y, palette.getPixel(rgb));
                int alpha = mask == null ? orig.getAlpha(x, y) : (mask.getPixel(x, y) == 1 ? 255 : 0);
                id.setAlpha(x, y, alpha);
                ++y;
            }
            ++x;
        }
        return id;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RGBAdjustmentImageDescriptor)) {
            return false;
        }
        RGBAdjustmentImageDescriptor other = (RGBAdjustmentImageDescriptor)((Object)obj);
        return other.desc.equals(this.desc) && other.r == this.r && other.g == this.g && other.b == this.b;
    }

    public int hashCode() {
        return this.desc.hashCode() ^ this.r ^ this.g ^ this.b;
    }
}

