/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class TreeDialog
extends Dialog {
    String title;
    String message;
    Label messageLabel;
    IInputValidator validator;
    Object initialSelection;
    Object[] selected;
    TreeViewer viewer;
    ILabelProvider labelProvider;
    IStructuredContentProvider contentProvider;
    Object input;
    boolean expandTree = false;
    boolean multipleSelection = false;
    boolean useDoubleClick = true;
    ViewerSorter sorter;

    public TreeDialog(Shell parentShell, String dialogTitle, String dialogMessage) {
        super(parentShell);
        this.message = dialogMessage;
        this.title = dialogTitle;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void buttonPressed(int buttonId) {
        IStructuredSelection ss;
        ISelection sel;
        this.selected = null;
        if (buttonId == 0 && (sel = this.viewer.getSelection()) instanceof IStructuredSelection && !(ss = (IStructuredSelection)sel).isEmpty()) {
            this.selected = ss.toArray();
        }
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.message != null) {
            this.messageLabel = new Label(composite, 64);
            this.messageLabel.setText(this.message);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            this.messageLabel.setLayoutData((Object)data);
            this.messageLabel.setFont(parent.getFont());
        }
        assert (this.input != null);
        assert (this.labelProvider != null);
        assert (this.contentProvider != null);
        int flags = 68352;
        if (this.multipleSelection) {
            flags |= 2;
        }
        this.viewer = new TreeViewer(parent, flags);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setSorter(this.sorter);
        this.viewer.setInput(this.input);
        if (this.useDoubleClick) {
            this.viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    TreeDialog.this.buttonPressed(0);
                }
            });
        }
        if (this.expandTree) {
            this.viewer.expandAll();
        }
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        gd.widthHint = 200;
        this.viewer.getTree().setLayoutData((Object)gd);
        if (this.initialSelection != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection(this.initialSelection));
        }
        TreeDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        if (this.viewer != null) {
            throw new IllegalStateException("Dialog is already initialized");
        }
        this.labelProvider = labelProvider;
    }

    public IStructuredContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setContentProvider(IStructuredContentProvider contentProvider) {
        if (this.viewer != null) {
            throw new IllegalStateException("Dialog is already initialized");
        }
        this.contentProvider = contentProvider;
    }

    public Object[] getSelected() {
        return this.selected;
    }

    public Object getSingleSelected() {
        if (this.selected == null || this.selected.length == 0) {
            return null;
        }
        return this.selected[0];
    }

    public Object getInitialSelection() {
        return this.initialSelection;
    }

    public void setInitialSelection(Object initialSelection) {
        if (this.viewer != null) {
            throw new IllegalStateException("Dialog is already initialized");
        }
        this.initialSelection = initialSelection;
    }

    public Object getInput() {
        return this.input;
    }

    public void setInput(Object inputElement) {
        if (this.viewer != null) {
            throw new IllegalStateException("Dialog is already initialized");
        }
        this.input = inputElement;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        if (this.viewer != null) {
            throw new IllegalStateException("Dialog is already initialized");
        }
        this.message = message;
    }

    public boolean isMultipleSelection() {
        return this.multipleSelection;
    }

    public void setMultipleSelection(boolean multipleSelection) {
        if (this.viewer != null) {
            throw new IllegalStateException("Dialog is already initialized");
        }
        this.multipleSelection = multipleSelection;
    }

    public void setUseDoubleClick(boolean useDoubleClick) {
        if (this.viewer != null) {
            throw new IllegalStateException("Dialog is already initialized");
        }
        this.useDoubleClick = useDoubleClick;
    }

    public boolean isUseDoubleClick() {
        return this.useDoubleClick;
    }

    public boolean isExpandTree() {
        return this.expandTree;
    }

    public void setExpandTree(boolean expandTree) {
        if (this.viewer != null) {
            throw new IllegalStateException("Dialog is already initialized");
        }
        this.expandTree = expandTree;
    }

    public void setSorter(ViewerSorter sorter) {
        if (this.viewer != null) {
            throw new IllegalStateException("Dialog is already initialized");
        }
        this.sorter = sorter;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }
}

