/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.color;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.simantics.utils.ui.color.Color;
import org.simantics.utils.ui.color.ColorIconCreator;

public class ColorCanvas
extends Canvas {
    Color color;
    int style;

    public ColorCanvas(Composite parent, int style) {
        super(parent, 2048);
        this.style = style & 0x300;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                Rectangle clip = gc.getClipping();
                if (ColorCanvas.this.color != null) {
                    Image image = ColorIconCreator.createImage(ColorCanvas.this.color, clip.width, clip.height);
                    gc.drawImage(image, 0, 0);
                    image.dispose();
                } else {
                    gc.setBackground(Display.getCurrent().getSystemColor(1));
                    gc.fillRectangle(clip);
                }
            }
        });
    }

    public void setColor(Color color) {
        this.color = color;
        this.redraw();
    }
}

