/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public final class BundleUtils {
    public static ImageDescriptor getImageDescriptorFromBundle(Bundle bundle, String imageFilePath) {
        if (bundle == null) {
            throw new IllegalArgumentException("null bundle");
        }
        if (imageFilePath == null) {
            throw new IllegalArgumentException("null image path");
        }
        if (!BundleUtils.isReady(bundle)) {
            return null;
        }
        URL fullPathString = FileLocator.find((Bundle)bundle, (IPath)new Path(imageFilePath), null);
        if (fullPathString == null) {
            try {
                fullPathString = new URL(imageFilePath);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return ImageDescriptor.createFromURL((URL)fullPathString);
    }

    public static ImageDescriptor getImageDescriptorFromPlugin(String pluginId, String imageFilePath) {
        if (pluginId == null || imageFilePath == null) {
            throw new IllegalArgumentException();
        }
        Bundle bundle = Platform.getBundle((String)pluginId);
        return BundleUtils.getImageDescriptorFromBundle(bundle, imageFilePath);
    }

    public static boolean isReady(Bundle bundle) {
        return bundle != null && BundleUtils.isReady(bundle.getState());
    }

    public static boolean isReady(int bundleState) {
        return (bundleState & 0x3C) != 0;
    }

    public static URL find(Bundle bundle, String path) {
        if (bundle == null) {
            return null;
        }
        return FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
    }

    public static URL find(String bundleId, String path) {
        return BundleUtils.find(Platform.getBundle((String)bundleId), path);
    }

    public static File findFile(String bundleId, String path) throws IOException {
        URL url = BundleUtils.find(bundleId, path);
        if (url == null) {
            return null;
        }
        url = FileLocator.toFileURL((URL)url);
        return new File(url.getPath());
    }

    public static File resolveWritableBundleFile(URL url) throws IOException {
        URL resolved = FileLocator.resolve((URL)url);
        if (resolved.getProtocol().equals("file")) {
            return new File(resolved.getPath());
        }
        return null;
    }
}

