/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.workbench.dialogs;

import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.workbench.StringMemento;

public class ColorDialog
extends org.simantics.utils.ui.color.ColorDialog {
    private static final int MAX_RECENT_COLORS = 8;
    public static final String RECENT_COLORS = "RECENT_COLORS";
    private static final String TAG_COLORS = "color";
    private static final String R_ATTR_NAME = "r";
    private static final String G_ATTR_NAME = "g";
    private static final String B_ATTR_NAME = "b";
    private static final String PLUGIN_ID = "org.simantics.utils.ui.workbench";
    protected Deque<org.simantics.utils.ui.color.Color> recentColors;

    public ColorDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.initRecent();
        Composite composite = (Composite)super.createDialogArea(parent);
        Group recentGroup = new Group(composite, 0);
        recentGroup.setText("Recent colors");
        GridLayoutFactory.fillDefaults().numColumns(8).spacing(2, 2).margins(4, 4).applyTo((Composite)recentGroup);
        int i = 0;
        for (org.simantics.utils.ui.color.Color color : this.recentColors) {
            ++i;
            this.createColorButton((Composite)recentGroup, color);
        }
        Color color = Display.getCurrent().getSystemColor(22);
        org.simantics.utils.ui.color.Color color2 = new org.simantics.utils.ui.color.Color(color.getRGB());
        while (i < 8) {
            Button button = this.createColorButton((Composite)recentGroup, color2);
            button.setEnabled(false);
            ++i;
        }
        return composite;
    }

    protected Point getInitialSize() {
        return new Point(400, 450);
    }

    private void initRecent() {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_ID);
        String recentString = store.getString(RECENT_COLORS);
        this.recentColors = ColorDialog.decodeColors(recentString);
    }

    private void storeRecent() {
        org.simantics.utils.ui.color.Color color = this.getColor();
        this.recentColors.remove(color);
        this.recentColors.addFirst(color);
        while (this.recentColors.size() > 8) {
            this.recentColors.removeLast();
        }
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_ID);
        store.putValue(RECENT_COLORS, ColorDialog.encodeColors(this.recentColors));
        if (store.needsSaving()) {
            try {
                store.save();
            }
            catch (IOException e) {
                ExceptionUtils.logError((Throwable)e);
            }
        }
    }

    protected void okPressed() {
        this.storeRecent();
        super.okPressed();
    }

    public static Deque<org.simantics.utils.ui.color.Color> decodeColors(String recentColorsPref) {
        LinkedList<org.simantics.utils.ui.color.Color> result = new LinkedList<org.simantics.utils.ui.color.Color>();
        try {
            StringMemento sm = new StringMemento(recentColorsPref);
            IMemento[] iMementoArray = sm.getChildren(TAG_COLORS);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento m = iMementoArray[n2];
                try {
                    int r = m.getInteger(R_ATTR_NAME);
                    int g = m.getInteger(G_ATTR_NAME);
                    int b = m.getInteger(B_ATTR_NAME);
                    org.simantics.utils.ui.color.Color c = new org.simantics.utils.ui.color.Color(r, g, b);
                    result.add(c);
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return result;
    }

    public static String encodeColors(Deque<org.simantics.utils.ui.color.Color> recentColors) {
        StringMemento sm = new StringMemento();
        for (org.simantics.utils.ui.color.Color c : recentColors) {
            IMemento m = sm.createChild(TAG_COLORS);
            m.putInteger(R_ATTR_NAME, c.getR());
            m.putInteger(G_ATTR_NAME, c.getG());
            m.putInteger(B_ATTR_NAME, c.getB());
        }
        return sm.toString();
    }
}

