package org.simantics.utils.ui.workbench.dialogs;

import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.color.Color;
import org.simantics.utils.ui.workbench.StringMemento;

/**
 * ColorDialog that keeps track used colors.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class ColorDialog extends org.simantics.utils.ui.color.ColorDialog{
	
	public ColorDialog(Shell parentShell) {
		super(parentShell);
	}

    
    protected Control createDialogArea(Composite parent) {
    	initRecent();
    	Composite composite = (Composite)super.createDialogArea(parent);
		Group recentGroup = new Group(composite, SWT.NONE);
		recentGroup.setText("Recent colors");
		GridLayoutFactory.fillDefaults().numColumns(8).spacing(2, 2).margins(4, 4).applyTo(recentGroup);
		int i = 0;
		for (Color c : recentColors) {
			i++;
			createColorButton(recentGroup, c);
		}
		org.eclipse.swt.graphics.Color c = Display.getCurrent().getSystemColor(SWT.COLOR_WIDGET_BACKGROUND);
		Color color = new Color(c.getRGB());
		for ( ; i < MAX_RECENT_COLORS; i++) {
			Button button = createColorButton(recentGroup, color);
			button.setEnabled(false);
		}
		return composite;
    }
    
    @Override
    protected Point getInitialSize() {
        return new Point(400, 450);
    }
    
	private static final int MAX_RECENT_COLORS = 8;
	
	public static final String  RECENT_COLORS = "RECENT_COLORS";

    private static final String TAG_COLORS                = "color";
    private static final String R_ATTR_NAME               = "r";
    private static final String G_ATTR_NAME               = "g";
    private static final String B_ATTR_NAME               = "b";
    
    private static final String PLUGIN_ID = "org.simantics.utils.ui.workbench";
    
    protected Deque<Color> recentColors;
    
    private void initRecent() {
    	 IPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_ID);
    	 String recentString = store.getString(RECENT_COLORS);
    	 recentColors = decodeColors(recentString);
    }
    
    private void storeRecent() {
    	Color color = getColor();
    	recentColors.remove(color);
    	recentColors.addFirst(color);
    	while(recentColors.size() > MAX_RECENT_COLORS)
    		recentColors.removeLast();
    	
    	IPersistentPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_ID);
    	store.putValue(RECENT_COLORS, encodeColors(recentColors));
    	
    	if (store.needsSaving())
    		try { 
    			store.save();
    		} catch (IOException e) {
    			ExceptionUtils.logError(e);
    		}
    }
    
    @Override
	protected void okPressed() {
		storeRecent();
		super.okPressed();
	}
    
    public static Deque<Color> decodeColors(String recentColorsPref) {
        Deque<Color> result = new LinkedList<Color>();
        try {
            StringMemento sm = new StringMemento(recentColorsPref);
            for (IMemento m : sm.getChildren(TAG_COLORS)) {
            	try {
	                int r = m.getInteger(R_ATTR_NAME);
	                int g = m.getInteger(G_ATTR_NAME);
	                int b = m.getInteger(B_ATTR_NAME);
	                Color c = new Color(r, g, b);
                	result.add(c);
                } catch (Exception e) {
                	
                }
                
            }
        } catch (IllegalArgumentException e) {
        }
        return result;
    }
    
    public static String encodeColors(Deque<Color> recentColors) {
        StringMemento sm = new StringMemento();
        for (Color c : recentColors) {
            IMemento m = sm.createChild(TAG_COLORS);
            m.putInteger(R_ATTR_NAME, c.getR());
            m.putInteger(G_ATTR_NAME, c.getG());
            m.putInteger(B_ATTR_NAME, c.getB());
        }
        return sm.toString();
    }
}
