package org.simantics.utils.ui.wizard;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.simantics.utils.ui.widgets.DirectorySelectionWidget;
import org.simantics.utils.ui.widgets.FileOrDirectorySelectionWidget;
import org.simantics.utils.ui.widgets.FileSelectionListener;

public class DirectorySelectionPage extends WizardPage implements FileSelectionListener{
	
	int style = SWT.OPEN;
	DirectorySelectionWidget directorySelectionWidget;
	Composite composite;
	
	public DirectorySelectionPage() {
		this("Select a directory",null);
	}
	
	public DirectorySelectionPage(String title, ImageDescriptor image) {
		this("DirectorySelection",title,image);
	}
	
	public DirectorySelectionPage(String pageName, String title, ImageDescriptor image) {
		super(pageName,title,image);
	}
	

	protected String getGroupName() {
		return "Directory:";
	}
	
	@Override
	public void createControl(Composite parent) {
		composite = new Composite(parent,SWT.NONE);
		composite.setLayout(new GridLayout(1,false));
		directorySelectionWidget = new DirectorySelectionWidget(composite, getGroupName(), style);
		directorySelectionWidget.addListener(this);
		setControl(composite);
		setPageComplete(false);
	}
	
	@Override
	public void fileSelected(FileOrDirectorySelectionWidget source,	String[] filename) {
		setPageComplete(filename != null && filename.length > 0);
	}
	
	
	public int getStyle() {
		return style;
	}
	
	public void setStyle(int style) {
		this.style = style;
	}
	
	public String[] getFilename() {
		return directorySelectionWidget.getFilename();
	}
	

}
