/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.validators;

import java.text.DecimalFormat;
import java.text.ParseException;

import org.eclipse.jface.dialogs.IInputValidator;

/**
 * validates all doubles
 * 
 * @author Toni Kalajainen
 */
public class DoubleValidator2 implements IInputValidator {

    public static DoubleValidator2 DOUBLE_VALIDATOR = new DoubleValidator2();
    
    public String isValid(String newText) {
        try {
            DecimalFormat.getInstance().parse(newText);
            return null;
        } catch (ParseException e) {
            return "\""+newText+"\" is not a numeric value";//;e.getMessage();
        }       
    }
}
