/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.validators;

import java.io.File;

import org.eclipse.jface.dialogs.IInputValidator;


/**
 * Check that input string is readable directory.
 * 
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class DirectoryNameValidator implements IInputValidator{
	
	@Override
	public String isValid(String newText) {
		File file = new File(newText);
		if (!file.exists())
			return "Directory does not exist.";
		if (!file.isDirectory())
			return "Selected path is a file.";
		if (!file.canRead())
			return "Directory is not readable.";
		return null;
	}

}
