/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.jface;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;

/**
 * @author Tuukka Lehtonen
 */
public class PostSelectionProvider extends BaseSelectionProvider implements IPostSelectionProvider {

    private ListenerList postSelectionListeners = new ListenerList();

    @Override
    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        postSelectionListeners.add(listener);
    }

    @Override
    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        postSelectionListeners.remove(listener);
    }

    protected Object[] getPostListeners() {
        return postSelectionListeners.getListeners();
    }

    /**
     * Notify other UIs that selection has changed
     * @param selection new selection
     */
    public void firePostSelection(ISelection selection) {
        SelectionChangedEvent e = new SelectionChangedEvent(this, selection); 
        for (Object l : getPostListeners())
            ((ISelectionChangedListener) l).selectionChanged(e);
    }

}
