/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.jface;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;

/**
 * A base implementation of ISelectionProvider that fires selection events on
 * {@link #setSelection(ISelection)} <strong>only if</strong> the selection
 * differs from the previous selection.
 * 
 * <p>
 * Contains an empty StructuredSelection by default. This version provides an
 * implementation that by default notifies of all selection changes that
 * actually changed the selection contents.
 * </p>
 * 
 * @author Tuukka Lehtonen
 */
public class ActiveSelectionProvider extends BaseSelectionProvider {

    /**
     * Create new ActiveSelectionProvider. Selection change notifications will
     * run synchronously in the thread that invoked
     * {@link ISelectionProvider#setSelection(ISelection)}.
     */
    public ActiveSelectionProvider() {
        super();
    }

    /**
     * Overrides default {@link BaseSelectionProvider#setSelection(ISelection)}
     * behaviour with the behaviour of
     * {@link BaseSelectionProvider#setAndFireNonEqualSelection(ISelection)}.
     */
    @Override
    public void setSelection(ISelection selection) {
        super.setAndFireNonEqualSelection(selection);
    }

}
