/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.internal;

import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.gfx.ImageCache;


/**
 * @author Tuukka Lehtonen
 */
@SuppressWarnings("deprecation")
public class Activator extends AbstractUIPlugin {

    // The plug-in ID
    public static final String PLUGIN_ID = "org.simantics.utils.ui";

    private static Activator instance;
    
    /** Error logger */
    private ErrorLogger errorLogger = new ErrorLogger(this);


    public Activator() {
        super();
        instance = this;
    }

    public static Activator getDefault() {
        return instance;
    }

    public ErrorLogger getErrorLogger() {
        return errorLogger;
    }  

    @Override
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        ImageCache.getInstance().dispose();
    }
}
